/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.mojo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;

abstract class AbstractPluginScannerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/repository")
    protected File repository;
    @Component
    protected BundleReader bundleReader;

    AbstractPluginScannerMojo() {
    }

    public void execute() throws MojoExecutionException {
        try {
            Properties properties = new Properties();
            File[] plugins = new File(this.repository, "plugins").listFiles();
            if (plugins != null) {
                HashMap<File, OsgiManifest> manifests = new HashMap<File, OsgiManifest>();
                for (File plugin : plugins) {
                    if (plugin.getName().endsWith(".pack.gz")) continue;
                    try {
                        OsgiManifest manifest = this.bundleReader.loadManifest(plugin);
                        manifests.put(plugin, manifest);
                    }
                    catch (OsgiManifestParserException e) {
                        this.getLog().error((Throwable)e);
                    }
                }
                this.processPlugins(properties, manifests);
            }
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.getDestination()));){
                properties.store(os, null);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not write plugin versions", e);
        }
    }

    protected abstract void processPlugins(Properties var1, Map<File, OsgiManifest> var2) throws Exception;

    protected abstract File getDestination();
}

