/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignMojo
extends AbstractMojo {
    private MavenProject project;
    private String signerUrl;
    private File workdir;
    private boolean skip;
    private boolean continueOnFail;
    private boolean excludeInnerJars;
    private List<String> supportedProjectTypes = Arrays.asList("jar", "bundle", "maven-plugin", "eclipse-plugin", "eclipse-test-plugin", "eclipse-feature");

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact signing");
            return;
        }
        if (!this.supportedProjectTypes.contains(this.project.getPackaging())) {
            this.getLog().debug((CharSequence)("Ignore unsupported project " + this.project));
            return;
        }
        this.signArtifact(this.project.getArtifact());
        for (Artifact artifact : this.project.getAttachedArtifacts()) {
            this.signArtifact(artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            File file = artifact.getFile();
            if (file == null || !file.isFile() || !file.canRead()) {
                this.getLog().warn((CharSequence)("Could not read artifact file, the artifact is not signed " + artifact));
                return;
            }
            if (!"jar".equals(artifact.getArtifactHandler().getExtension())) {
                this.getLog().debug((CharSequence)("Artifact extention is not ``jar'', the artifact is not signed " + artifact));
                return;
            }
            if (!this.shouldSign(file)) {
                this.getLog().info((CharSequence)("Signing of " + artifact + " is disabled in META-INF/eclipse.inf, the artifact is not signed."));
                return;
            }
            ArrayList<String> innerJars = new ArrayList<String>();
            if (this.excludeInnerJars) {
                this.getLog().info((CharSequence)("Signing of inner jars for " + artifact + " is disabled, inner jars will not be signed."));
            } else {
                this.getLog().info((CharSequence)("Searching " + file.getName() + " for inner jars..."));
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry = jarEntries.nextElement();
                    if (!"jar".equals(FileUtils.getExtension((String)entry.getName()))) continue;
                    this.getLog().debug((CharSequence)("Inner jar found: " + entry.getName()));
                    innerJars.add(entry.getName());
                }
            }
            long start = System.currentTimeMillis();
            this.workdir.mkdirs();
            if (!this.excludeInnerJars && innerJars.size() > 0) {
                this.signInnerJars(file, innerJars);
            }
            File tempSigned = File.createTempFile(file.getName(), ".signed-jar", this.workdir);
            try {
                this.signFile(file, tempSigned);
                if (!tempSigned.canRead() || tempSigned.length() <= 0L) {
                    String msg = "Could not sign artifact " + artifact;
                    if (this.continueOnFail) {
                        this.getLog().warn((CharSequence)msg);
                    } else {
                        throw new MojoExecutionException(msg);
                    }
                }
                FileUtils.copyFile((File)tempSigned, (File)file);
            }
            finally {
                tempSigned.delete();
            }
            this.getLog().info((CharSequence)("Signed " + artifact + " in " + (System.currentTimeMillis() - start) / 1000L + " seconds."));
        }
        catch (IOException e) {
            String msg = "Could not sign artifact " + artifact;
            if (this.continueOnFail) {
                this.getLog().warn((CharSequence)msg);
            }
            throw new MojoExecutionException(msg, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldSign(File file) throws IOException {
        boolean sign;
        block6: {
            sign = true;
            JarFile jar = new JarFile(file);
            try {
                ZipEntry entry = jar.getEntry("META-INF/eclipse.inf");
                if (entry == null) break block6;
                InputStream is = jar.getInputStream(entry);
                Properties eclipseInf = new Properties();
                try {
                    eclipseInf.load(is);
                }
                finally {
                    is.close();
                }
                sign = !Boolean.parseBoolean(eclipseInf.getProperty("jarprocessor.exclude")) && !Boolean.parseBoolean(eclipseInf.getProperty("jarprocessor.exclude.sign"));
            }
            finally {
                jar.close();
            }
        }
        return sign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signFile(File source, File target) throws IOException, MojoExecutionException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.signerUrl);
        MultipartEntity reqEntity = new MultipartEntity();
        reqEntity.addPart("file", (ContentBody)new FileBody(source));
        post.setEntity((HttpEntity)reqEntity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity resEntity = response.getEntity();
        if (statusCode >= 200 && statusCode <= 299 && resEntity != null) {
            InputStream is = resEntity.getContent();
            try {
                FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(is), (File)target);
            }
            finally {
                IOUtil.close((InputStream)is);
            }
        } else {
            throw new MojoExecutionException("Signer replied " + response.getStatusLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signInnerJars(File file, List<String> innerJars) throws IOException, FileNotFoundException, MojoExecutionException {
        JarFile jar = new JarFile(file);
        File nestedWorkdir = new File(this.workdir + File.separator + "sign-innner-jars");
        nestedWorkdir.mkdirs();
        Enumeration<JarEntry> extractFiles = jar.entries();
        while (extractFiles.hasMoreElements()) {
            JarEntry entry = extractFiles.nextElement();
            File f = new File(nestedWorkdir + File.separator + entry.getName());
            if (entry.isDirectory()) {
                f.mkdir();
                continue;
            }
            if (f.getParentFile().mkdirs()) {
                this.getLog().debug((CharSequence)("Created missing directory " + f.getParent()));
            }
            InputStream is = jar.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        Iterator<String> it = innerJars.iterator();
        while (it.hasNext()) {
            long start = System.currentTimeMillis();
            String jarToSign = it.next();
            File unsignedJar = new File(nestedWorkdir, jarToSign);
            File tempSignedJar = new File(nestedWorkdir, jarToSign + ".signed-jar");
            this.signFile(unsignedJar, tempSignedJar);
            FileUtils.copyFile((File)tempSignedJar, (File)unsignedJar);
            tempSignedJar.delete();
            this.getLog().info((CharSequence)("Signed " + jarToSign + " in " + (System.currentTimeMillis() - start) / 1000L + " seconds."));
        }
        File tempJar = File.createTempFile(file.getName(), ".create-jar", this.workdir);
        try {
            this.getLog().debug((CharSequence)("Creating jar " + file.getName()));
            this.createJar(tempJar, nestedWorkdir);
            if (!tempJar.canRead() || tempJar.length() <= 0L) {
                throw new MojoExecutionException("Could not create jar " + file.getName());
            }
            FileUtils.copyFile((File)tempJar, (File)file);
        }
        finally {
            tempJar.delete();
        }
        FileUtils.deleteDirectory((File)nestedWorkdir);
    }

    private void createJar(File jarFile, File jarDir) throws IOException, FileNotFoundException {
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        for (File f : FileUtils.getFiles((File)jarDir, (String)"**/*", (String)"", (boolean)false)) {
            JarEntry entry;
            this.getLog().debug((CharSequence)("   " + f.getPath()));
            if (f.isDirectory()) {
                entry = new JarEntry(f.getPath().replace("\\", "/") + "/");
                entry.setTime(f.lastModified());
                jos.putNextEntry(entry);
                this.getLog().info((CharSequence)("Directory: " + entry.getName()));
            } else {
                int count;
                entry = new JarEntry(f.getPath().replace("\\", "/"));
                entry.setTime(f.lastModified());
                jos.putNextEntry(entry);
                File writeFile = new File(jarDir, f.getPath());
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(writeFile));
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    jos.write(buffer, 0, count);
                }
                if (in != null) {
                    in.close();
                }
            }
            jos.closeEntry();
        }
        jos.close();
    }
}

