/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.cbi.maven.plugins.jarsigner.FilteredJarSigner;

public class EclipseJarSignerFilter
implements FilteredJarSigner.Filter {
    private static final String JARPROCESSOR_EXCLUDE_SIGN = "jarprocessor.exclude.sign";
    private static final String JARPROCESSOR_EXCLUDE = "jarprocessor.exclude";
    private static final String META_INF_ECLIPSE_INF = "META-INF/eclipse.inf";
    static final String DOT_JAR_GLOB_PATTERN = "glob:**.jar";
    private final Log log;

    public EclipseJarSignerFilter(Log log) {
        this.log = log;
    }

    @Override
    public boolean shouldBeSigned(Path file) throws IOException {
        boolean ret;
        if (file == null || !Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            this.log.warn((CharSequence)("Can not read file '" + file + "', it will not be signed"));
            ret = false;
        } else if (!file.getFileSystem().getPathMatcher(DOT_JAR_GLOB_PATTERN).matches(file)) {
            this.log.debug((CharSequence)("Extension of file '" + file + "' is not 'jar', it will not be signed"));
            ret = false;
        } else if (EclipseJarSignerFilter.isDisabledInEclipseInf(file)) {
            this.log.info((CharSequence)("Signing of file '" + file + "' is disabled in '" + META_INF_ECLIPSE_INF + "', it will not be signed."));
            ret = false;
        } else {
            ret = true;
        }
        return ret;
    }

    private static boolean isDisabledInEclipseInf(Path file) throws IOException {
        boolean isDisabled = false;
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(file, new OpenOption[0]));){
            boolean found = false;
            ZipEntry entry = zis.getNextEntry();
            while (!found && entry != null) {
                if (META_INF_ECLIPSE_INF.equals(entry.getName())) {
                    found = true;
                    Properties eclipseInf = new Properties();
                    eclipseInf.load(zis);
                    isDisabled = Boolean.parseBoolean(eclipseInf.getProperty(JARPROCESSOR_EXCLUDE)) || Boolean.parseBoolean(eclipseInf.getProperty(JARPROCESSOR_EXCLUDE_SIGN));
                }
                entry = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new IOException("Error occured while checking if the signing of jar '" + file + "' was disabled in '" + META_INF_ECLIPSE_INF + "'", e);
        }
        return isDisabled;
    }
}

