/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface ImmutableShortBag extends ImmutableShortCollection, ShortBag
{
    ImmutableShortBag select(ShortPredicate predicate);

    ImmutableShortBag reject(ShortPredicate predicate);

    <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function);

    ImmutableShortBag newWith(short element);

    ImmutableShortBag newWithout(short element);

    ImmutableShortBag newWithAll(ShortIterable elements);

    ImmutableShortBag newWithoutAll(ShortIterable elements);
}
