/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.set.ImmutableSet;

/**
 * This file was automatically generated from template file immutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface ImmutableBooleanSet extends ImmutableBooleanCollection, BooleanSet
{
    ImmutableBooleanSet select(BooleanPredicate predicate);

    ImmutableBooleanSet reject(BooleanPredicate predicate);

    <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableBooleanSet newWith(boolean element);

    ImmutableBooleanSet newWithout(boolean element);

    ImmutableBooleanSet newWithAll(BooleanIterable elements);

    ImmutableBooleanSet newWithoutAll(BooleanIterable elements);
}
