/*
 * Copyright (c) 2024 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.factory.map.primitive.MutableObjectByteHashingStrategyMapFactory;
import org.eclipse.collections.api.map.primitive.MutableObjectByteMap;

/**
 * MutableObjectByteHashingStrategyMapFactoryImpl is a factory implementation which creates instances of type {@link MutableObjectByteMap}.
 * This file was automatically generated from template file mutableObjectPrimitiveHashingStrategyMapFactoryImpl.stg.
 *
 * @since 11.1.
 */
@aQute.bnd.annotation.spi.ServiceProvider(MutableObjectByteHashingStrategyMapFactory.class)
public class MutableObjectByteHashingStrategyMapFactoryImpl implements MutableObjectByteHashingStrategyMapFactory
{
    public static final MutableObjectByteHashingStrategyMapFactory INSTANCE = new MutableObjectByteHashingStrategyMapFactoryImpl();

    @Override
    public <K> MutableObjectByteMap<K> empty(HashingStrategy<? super K> hashingStrategy)
    {
        return ObjectByteHashMapWithHashingStrategy.newMap(hashingStrategy);
    }

    @Override
    public <K> MutableObjectByteMap<K> of(HashingStrategy<? super K> hashingStrategy)
    {
        return this.empty(hashingStrategy);
    }

    @Override
    public <K> MutableObjectByteMap<K> with(HashingStrategy<? super K> hashingStrategy)
    {
        return this.empty(hashingStrategy);
    }

    @Override
    public <K> MutableObjectByteMap<K> withInitialCapacity(HashingStrategy<? super K> hashingStrategy, int initialCapacity)
    {
        return ObjectByteHashMapWithHashingStrategy.newMapWithInitialCapacity(hashingStrategy, initialCapacity);
    }
}
