/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.map.primitive.ImmutableIntObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.IntObjectMap;

/**
 * ImmutableIntObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntObjectMapFactoryImpl implements ImmutableIntObjectMapFactory
{
    public <V> ImmutableIntObjectMap<V> empty()
    {
        return (ImmutableIntObjectMap<V>) ImmutableIntObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableIntObjectMap<V> of()
    {
        return this.empty();
    }

    public <V> ImmutableIntObjectMap<V> with()
    {
        return this.empty();
    }

    public <V> ImmutableIntObjectMap<V> of(int key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableIntObjectMap<V> with(int key, V value)
    {
        return new ImmutableIntObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableIntObjectMap<V> ofAll(IntObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableIntObjectMap<V> withAll(IntObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableIntObjectMap)
        {
            return (ImmutableIntObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final int[] array = new int[1];
            map.forEachKey(new IntProcedure()
            {
                public void value(int each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableIntObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableIntObjectHashMap<V>(map);
    }
}
