/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongBooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.map.primitive.LongBooleanMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableLongBooleanMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.tuple.primitive.LongBooleanPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongBooleanProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.map.mutable.primitive.LongBooleanHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

/**
 * ImmutableLongBooleanHashMap is the non-modifiable equivalent of {@link LongBooleanHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableLongBooleanHashMap implements ImmutableLongBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableLongBooleanMap delegate;

    ImmutableLongBooleanHashMap(LongBooleanMap delegate)
    {
        this.delegate = new LongBooleanHashMap(delegate);
    }

    public boolean get(long key)
    {
        return this.delegate.get(key);
    }

    public boolean getIfAbsent(long key, boolean ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(long key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(boolean value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongBooleanProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<LongBooleanPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongBooleanMap select(LongBooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBooleanMap reject(LongBooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableLongBooleanMap toImmutable()
    {
        return this;
    }

    public BooleanIterator booleanIterator()
    {
        return new UnmodifiableBooleanIterator(this.delegate.booleanIterator());
    }

    public void forEach(BooleanProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(BooleanProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BooleanPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public boolean[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(boolean value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(boolean... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableBooleanList toList()
    {
        return this.delegate.toList();
    }

    public MutableBooleanSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableLongBooleanMap newWithKeyValue(long key, boolean value)
    {
        MutableLongBooleanMap map = new LongBooleanHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongBooleanMap newWithoutKey(long key)
    {
        MutableLongBooleanMap map = new LongBooleanHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongBooleanMap newWithoutAllKeys(LongIterable keys)
    {
        MutableLongBooleanMap map = new LongBooleanHashMap(this.size());
        map.putAll(this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet()
    {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableBooleanCollection values()
    {
        return UnmodifiableBooleanCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableLongBooleanMapSerializationProxy(this);
    }

    protected static class ImmutableLongBooleanMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private LongBooleanMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableLongBooleanMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableLongBooleanMapSerializationProxy(LongBooleanMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedLongBooleanProcedure()
                {
                    @Override
                    public void safeValue(long key, boolean value) throws IOException
                    {
                        out.writeLong(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableLongBooleanMap deserializedMap = new LongBooleanHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readLong(), in.readBoolean());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
