/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortDoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.ImmutableShortDoubleMap;
import org.eclipse.collections.api.map.primitive.ShortDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortDoublePair;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ShortDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ShortDoubleHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortDoubleSingletonMap
implements ImmutableShortDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    private final short key1;
    private final double value1;

    ImmutableShortDoubleSingletonMap(short key1, double value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public double get(short key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(short key, double ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public double getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    public boolean containsValue(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    public void forEachValue(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ShortDoubleProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyShortIterable keysView() {
        return ShortLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ShortDoublePair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableShortDoubleMap select(ShortDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortDoubleHashMap().toImmutable();
    }

    public ImmutableShortDoubleMap reject(ShortDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortDoubleHashMap().toImmutable() : ShortDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableShortDoubleMap toImmutable() {
        return this;
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)ShortDoubleHashMap.newWithKeysValues(this.key1, this.value1).doubleIterator());
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum() {
        return this.value1;
    }

    public double min() {
        return this.value1;
    }

    public double max() {
        return this.value1;
    }

    public double maxIfEmpty(double defaultValue) {
        return this.value1;
    }

    public double minIfEmpty(double defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public double[] toSortedArray() {
        return new double[]{this.value1};
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? DoubleArrayList.newListWith(this.value1).toImmutable() : new DoubleArrayList().toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? new DoubleArrayList().toImmutable() : DoubleArrayList.newListWith(this.value1).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public double[] toArray() {
        return new double[]{this.value1};
    }

    public boolean contains(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.value1);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.value1);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableShortDoubleMap newWithKeyValue(short key, double value) {
        return ShortDoubleMaps.immutable.withAll((ShortDoubleMap)ShortDoubleHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableShortDoubleMap newWithoutKey(short key) {
        return this.key1 == key ? ShortDoubleMaps.immutable.with() : this;
    }

    public ImmutableShortDoubleMap newWithoutAllKeys(ShortIterable keys) {
        return keys.contains(this.key1) ? ShortDoubleMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(ShortHashSet.newSetWith(this.key1));
    }

    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of((MutableDoubleCollection)DoubleArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortDoubleMap)) {
            return false;
        }
        ShortDoubleMap map = (ShortDoubleMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Double.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    public int hashCode() {
        return this.key1 ^ (int)(Double.doubleToLongBits(this.value1) ^ Double.doubleToLongBits(this.value1) >>> 32);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

