/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCMDescriptor;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GitTool
extends ToolInstallation
implements NodeSpecific<GitTool>,
EnvironmentSpecific<GitTool> {
    static final transient String defaultValueName = "Default";

    @DataBoundConstructor
    public GitTool(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public String getGitExe() {
        return this.getHome();
    }

    public static void onLoaded() {
        DescriptorImpl descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptor(GitTool.class);
        GitTool[] installations = GitTool.getInstallations(descriptor);
        if (installations.length > 0) {
            return;
        }
        DescriptorExtensionList scms = GitSCM.all();
        String defaultGitExe = File.separatorChar != '/' ? "git.exe" : "git";
        for (SCMDescriptor s : scms) {
            GitSCM.DescriptorImpl desc;
            if (!(s instanceof GitSCM.DescriptorImpl) || (desc = (GitSCM.DescriptorImpl)s).getOldGitExe() == null) continue;
            defaultGitExe = desc.getOldGitExe();
        }
        GitTool tool = new GitTool(defaultValueName, defaultGitExe, Collections.emptyList());
        descriptor.setInstallations(new GitTool[]{tool});
        descriptor.save();
    }

    private static GitTool[] getInstallations(DescriptorImpl descriptor) {
        GitTool[] installations = null;
        try {
            installations = (GitTool[])descriptor.getInstallations();
        }
        catch (NullPointerException e) {
            installations = new GitTool[]{};
        }
        return null == installations ? new GitTool[]{} : installations;
    }

    public GitTool forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GitTool(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public GitTool forEnvironment(EnvVars environment) {
        return new GitTool(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(GitTool.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<GitTool> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            String path = value.getPath();
            return FormValidation.validateExecutable((String)path);
        }
    }
}

