/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.keys.KeySequence;

public abstract class AbstractInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    protected StringMatcher fStringMatcher;
    private ICommand fInvokingCommand;
    private KeySequence[] fInvokingCommandKeySequences;
    private Composite fViewMenuButtonComposite;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private IAction fShowViewMenuAction;
    private HandlerSubmission fShowViewMenuHandlerSubmission;
    private int fTreeStyle;
    private IType fInitiallySelectedType;

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle, String invokingCommandId, boolean showStatusField) {
        super(parent, shellStyle, true, true, false, true, true, null, null);
        if (invokingCommandId != null) {
            ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
            this.fInvokingCommand = commandManager.getCommand(invokingCommandId);
            if (this.fInvokingCommand != null && !this.fInvokingCommand.isDefined()) {
                this.fInvokingCommand = null;
            } else {
                this.getInvokingCommandKeySequences();
            }
        }
        this.fTreeStyle = treeStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected Control createDialogArea(Composite parent) {
        this.fTreeViewer = this.createTreeViewer(parent, this.fTreeStyle);
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.getId(), (StructuredViewer)this.fTreeViewer);
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    Rectangle clientArea = tree.getClientArea();
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y - clientArea.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (clientArea.y + clientArea.height - e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.installFilter();
        this.addDisposeListener(this);
        return this.fTreeViewer.getControl();
    }

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this(parent, shellStyle, treeStyle, null, false);
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

    protected abstract String getId();

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.fFilterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.fFilterText;
    }

    protected void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    protected void updateStatusFieldText() {
        this.setInfoText(this.getStatusFieldText());
    }

    protected String getStatusFieldText() {
        return "";
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                AbstractInformationControl.this.setMatcherString(text, true);
            }
        });
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String pattern, boolean update) {
        if (pattern.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.fStringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                IEditorPart part = EditorUtility.openInEditor(selectedElement, true);
                if (part != null && selectedElement instanceof IJavaElement) {
                    EditorUtility.revealInEditor(part, (IJavaElement)selectedElement);
                }
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
            }
        }
    }

    protected void selectFirstMatch() {
        Widget selectedElement = this.fTreeViewer.testFindItem((Object)this.fInitiallySelectedType);
        Tree tree = this.fTreeViewer.getTree();
        TreeItem element = selectedElement instanceof TreeItem ? this.findElement(new TreeItem[]{(TreeItem)selectedElement}) : this.findElement(tree.getItems());
        if (element != null) {
            tree.setSelection(element);
            tree.showItem(element);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private TreeItem findElement(TreeItem[] items) {
        return this.findElement(items, null, true);
    }

    private TreeItem findElement(TreeItem[] items, TreeItem[] toBeSkipped, boolean allowToGoUp) {
        TreeItem item;
        if (this.fStringMatcher == null) {
            return items.length > 0 ? items[0] : null;
        }
        ILabelProvider labelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            String label;
            item = items[i];
            IJavaElement element = (IJavaElement)item.getData();
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText((Object)element))) {
                return item;
            }
            ++i;
        }
        i = 0;
        while (i < items.length) {
            item = items[i];
            TreeItem foundItem = this.findElement(this.selectItems(item.getItems(), toBeSkipped), null, false);
            if (foundItem != null) {
                return foundItem;
            }
            ++i;
        }
        if (!allowToGoUp || items.length == 0) {
            return null;
        }
        TreeItem parentItem = items[0].getParentItem();
        if (parentItem != null) {
            return this.findElement(new TreeItem[]{parentItem}, items, true);
        }
        return this.findElement(this.selectItems(items[0].getParent().getItems(), items), null, false);
    }

    private boolean canSkip(TreeItem item, TreeItem[] toBeSkipped) {
        if (toBeSkipped == null) {
            return false;
        }
        int i = 0;
        while (i < toBeSkipped.length) {
            if (toBeSkipped[i] == item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private TreeItem[] selectItems(TreeItem[] items, TreeItem[] toBeSkipped) {
        if (toBeSkipped == null || toBeSkipped.length == 0) {
            return items;
        }
        int j = 0;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (!this.canSkip(item, toBeSkipped)) {
                items[j++] = item;
            }
            ++i;
        }
        if (j == items.length) {
            return items;
        }
        TreeItem[] result = new TreeItem[j];
        System.arraycopy(items, 0, result, 0, j);
        return result;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void fillViewMenu(IMenuManager viewMenu) {
        this.fCustomFiltersActionGroup.fillViewMenu(viewMenu);
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    protected void inputChanged(Object newInput, Object newSelection) {
        this.fFilterText.setText("");
        this.fTreeViewer.setInput(newInput);
        this.fInitiallySelectedType = null;
        if (newSelection instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)newSelection;
            this.fInitiallySelectedType = javaElement.getElementType() == 7 ? (IType)javaElement : (IType)javaElement.getAncestor(7);
        }
        if (newSelection != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.removeHandlerAndKeyBindingSupport();
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public int open() {
        this.addHandlerAndKeyBindingSupport();
        return super.open();
    }

    public final void dispose() {
        this.close();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.removeHandlerAndKeyBindingSupport();
        this.fTreeViewer = null;
        this.fFilterText = null;
    }

    protected void addHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission == null) {
            this.fShowViewMenuHandlerSubmission = new HandlerSubmission(null, this.getShell(), null, this.fShowViewMenuAction.getActionDefinitionId(), (IHandler)new ActionHandler(this.fShowViewMenuAction), Priority.MEDIUM);
            PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(this.fShowViewMenuHandlerSubmission);
        }
    }

    protected void removeHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission != null) {
            PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(this.fShowViewMenuHandlerSubmission);
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected final ICommand getInvokingCommand() {
        return this.fInvokingCommand;
    }

    protected final KeySequence[] getInvokingCommandKeySequences() {
        List list;
        if (this.fInvokingCommandKeySequences == null && this.getInvokingCommand() != null && !(list = this.getInvokingCommand().getKeySequenceBindings()).isEmpty()) {
            this.fInvokingCommandKeySequences = new KeySequence[list.size()];
            int i = 0;
            while (i < this.fInvokingCommandKeySequences.length) {
                this.fInvokingCommandKeySequences[i] = ((IKeySequenceBinding)list.get(i)).getKeySequence();
                ++i;
            }
            return this.fInvokingCommandKeySequences;
        }
        return this.fInvokingCommandKeySequences;
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = JavaPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.fFilterText = this.createFilterText(parent);
        }
        this.fShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                AbstractInformationControl.this.showDialogMenu();
            }
        };
        this.fShowViewMenuAction.setEnabled(true);
        this.fShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.fFilterText = this.createFilterText(parent);
        return this.fFilterText;
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.fFilterText, this.fTreeViewer.getTree()});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.fFilterText});
            composite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.fTreeViewer.getTree()});
        }
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = AbstractInformationControl.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if ((matchName = TextProcessor.deprocess((String)matchName)) != null && matcher.match(matchName)) {
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            if (element instanceof IParent) {
                Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
                int i = 0;
                while (i < children.length) {
                    if (this.select((Viewer)viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

