/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi.modules;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.jetty.security.CrossContextPsuedoSession;
import org.eclipse.jetty.security.authentication.LoginCallbackImpl;
import org.eclipse.jetty.security.jaspi.modules.BaseAuthModule;
import org.eclipse.jetty.security.jaspi.modules.UserInfo;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Password;

public class FormAuthModule
extends BaseAuthModule {
    private static final Logger LOG = Log.getLogger(FormAuthModule.class);
    public static final String __J_URI = "org.eclipse.jetty.util.URI";
    public static final String __J_AUTHENTICATED = "org.eclipse.jetty.server.Auth";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    public static final String LOGIN_PAGE_KEY = "org.eclipse.jetty.security.jaspi.modules.LoginPage";
    public static final String ERROR_PAGE_KEY = "org.eclipse.jetty.security.jaspi.modules.ErrorPage";
    public static final String SSO_SOURCE_KEY = "org.eclipse.jetty.security.jaspi.modules.SsoSource";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private CrossContextPsuedoSession<UserInfo> ssoSource;

    public FormAuthModule() {
    }

    public FormAuthModule(CallbackHandler callbackHandler, String loginPage, String errorPage) {
        super(callbackHandler);
        this.setLoginPage(loginPage);
        this.setErrorPage(errorPage);
    }

    public FormAuthModule(CallbackHandler callbackHandler, CrossContextPsuedoSession<UserInfo> ssoSource, String loginPage, String errorPage) {
        super(callbackHandler);
        this.ssoSource = ssoSource;
        this.setLoginPage(loginPage);
        this.setErrorPage(errorPage);
    }

    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        super.initialize(requestPolicy, responsePolicy, handler, options);
        this.setLoginPage((String)options.get(LOGIN_PAGE_KEY));
        this.setErrorPage((String)options.get(ERROR_PAGE_KEY));
        this.ssoSource = (CrossContextPsuedoSession)options.get(SSO_SOURCE_KEY);
    }

    private void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            LOG.warn("form-login-page must start with /", new Object[0]);
            path = "/" + path;
        }
        this._formLoginPage = path;
        this._formLoginPath = path;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    private void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!path.startsWith("/")) {
                LOG.warn("form-error-page must start with /", new Object[0]);
                path = "/" + path;
            }
            this._formErrorPage = path;
            this._formErrorPath = path;
            if (this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        HttpSession session = request.getSession(this.isMandatory(messageInfo));
        String uri = request.getPathInfo();
        if (session == null || this.isLoginOrErrorPage(uri)) {
            return AuthStatus.SUCCESS;
        }
        try {
            boolean success;
            UserInfo userInfo;
            boolean success2;
            if (uri.endsWith(__J_SECURITY_CHECK)) {
                String password;
                String username = request.getParameter(__J_USERNAME);
                boolean success3 = this.tryLogin(messageInfo, clientSubject, response, session, username, new Password(password = request.getParameter(__J_PASSWORD)));
                if (success3) {
                    String nuri = (String)session.getAttribute(__J_URI);
                    if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                        nuri = "/";
                    }
                    session.removeAttribute(__J_URI);
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(nuri));
                    return AuthStatus.SEND_CONTINUE;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Form authentication FAILED for " + StringUtil.printable(username), new Object[0]);
                }
                if (this._formErrorPage == null) {
                    if (response != null) {
                        response.sendError(403);
                    }
                } else {
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formErrorPage)));
                }
                return AuthStatus.SEND_FAILURE;
            }
            FormCredential form_cred = (FormCredential)session.getAttribute(__J_AUTHENTICATED);
            if (form_cred != null ? (success2 = this.tryLogin(messageInfo, clientSubject, response, session, form_cred._jUserName, new Password(new String(form_cred._jPassword)))) : this.ssoSource != null && (userInfo = this.ssoSource.fetch(request)) != null && (success = this.tryLogin(messageInfo, clientSubject, response, session, userInfo.getUserName(), new Password(new String(userInfo.getPassword()))))) {
                return AuthStatus.SUCCESS;
            }
            if (!this.isMandatory(messageInfo) || this.isLoginOrErrorPage(uri)) {
                return AuthStatus.SUCCESS;
            }
            if (request.getQueryString() != null) {
                uri = uri + "?" + request.getQueryString();
            }
            session.setAttribute(__J_URI, (Object)(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + URIUtil.addPaths(request.getContextPath(), uri)));
            response.setContentLength(0);
            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this._formLoginPage)));
            return AuthStatus.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
    }

    private boolean tryLogin(MessageInfo messageInfo, Subject clientSubject, HttpServletResponse response, HttpSession session, String username, Password password) throws AuthException, IOException, UnsupportedCallbackException {
        if (this.login(clientSubject, username, password, "FORM", messageInfo)) {
            char[] pwdChars = password.toString().toCharArray();
            Set<LoginCallbackImpl> loginCallbacks = clientSubject.getPrivateCredentials(LoginCallbackImpl.class);
            if (!loginCallbacks.isEmpty()) {
                LoginCallbackImpl loginCallback = loginCallbacks.iterator().next();
                FormCredential form_cred = new FormCredential(username, pwdChars, loginCallback.getUserPrincipal());
                session.setAttribute(__J_AUTHENTICATED, (Object)form_cred);
            }
            if (this.ssoSource != null) {
                UserInfo userInfo = new UserInfo(username, pwdChars);
                this.ssoSource.store(userInfo, response);
            }
            return true;
        }
        return false;
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this._formErrorPath) || pathInContext.equals(this._formLoginPath));
    }

    private static class FormCredential
    implements Serializable,
    HttpSessionBindingListener {
        String _jUserName;
        char[] _jPassword;
        transient Principal _userPrincipal;

        private FormCredential(String _jUserName, char[] _jPassword, Principal _userPrincipal) {
            this._jUserName = _jUserName;
            this._jPassword = _jPassword;
            this._userPrincipal = _userPrincipal;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Logout " + this._jUserName, new Object[0]);
            }
        }

        public int hashCode() {
            return this._jUserName.hashCode() + this._jPassword.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FormCredential)) {
                return false;
            }
            FormCredential fc = (FormCredential)o;
            return this._jUserName.equals(fc._jUserName) && Arrays.equals(this._jPassword, fc._jPassword);
        }

        public String toString() {
            return "Cred[" + this._jUserName + "]";
        }
    }
}

