/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Random;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.RandomMaskGen;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketConnectionD13;

public class WebSocketClientFactory
extends AggregateLifeCycle {
    private static final Logger __log = Log.getLogger(WebSocketClientFactory.class.getName());
    private static final Random __random = new Random();
    private static final ByteArrayBuffer __ACCEPT = new ByteArrayBuffer.CaseInsensitive("Sec-WebSocket-Accept");
    private final ThreadPool _threadPool;
    private final WebSocketClientSelector _selector;
    private MaskGen _maskGen;
    private WebSocketBuffers _buffers;

    public WebSocketClientFactory() {
        this._threadPool = new QueuedThreadPool();
        this.addBean(this._threadPool);
        this._buffers = new WebSocketBuffers(8192);
        this.addBean(this._buffers);
        this._maskGen = new RandomMaskGen();
        this.addBean(this._maskGen);
        this._selector = new WebSocketClientSelector();
        this.addBean(this._selector);
    }

    public WebSocketClientFactory(ThreadPool threadPool) {
        this._threadPool = threadPool;
        this.addBean(threadPool);
        this._buffers = new WebSocketBuffers(8192);
        this.addBean(this._buffers);
        this._maskGen = new RandomMaskGen();
        this.addBean(this._maskGen);
        this._selector = new WebSocketClientSelector();
        this.addBean(this._selector);
    }

    public WebSocketClientFactory(ThreadPool threadPool, MaskGen maskGen, int bufferSize) {
        this._threadPool = threadPool;
        this.addBean(threadPool);
        this._buffers = new WebSocketBuffers(bufferSize);
        this.addBean(this._buffers);
        this._maskGen = maskGen;
        this._selector = new WebSocketClientSelector();
        this.addBean(this._selector);
    }

    public SelectorManager getSelectorManager() {
        return this._selector;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public MaskGen getMaskGen() {
        return this._maskGen;
    }

    public void setMaskGen(MaskGen maskGen) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        if (this.removeBean(this._maskGen)) {
            this.addBean(maskGen);
        }
        this._maskGen = maskGen;
    }

    public void setBufferSize(int bufferSize) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this.removeBean(this._buffers);
        this._buffers = new WebSocketBuffers(bufferSize);
        this.addBean(this._buffers);
    }

    public int getBufferSize() {
        return this._buffers.getBufferSize();
    }

    public WebSocketClient newWebSocketClient() {
        return new WebSocketClient(this);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.getThreadPool() instanceof LifeCycle && !((LifeCycle)((Object)this.getThreadPool())).isStarted()) {
            ((LifeCycle)((Object)this.getThreadPool())).start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    class HandshakeConnection
    extends AbstractConnection
    implements AsyncConnection {
        private final AsyncEndPoint _endp;
        private final WebSocketClient.WebSocketFuture _future;
        private final String _key;
        private final HttpParser _parser;
        private String _accept;
        private String _error;

        public HandshakeConnection(AsyncEndPoint endpoint, WebSocketClient.WebSocketFuture future) {
            super(endpoint, System.currentTimeMillis());
            this._endp = endpoint;
            this._future = future;
            byte[] bytes = new byte[16];
            __random.nextBytes(bytes);
            this._key = new String(B64Code.encode(bytes));
            SimpleBuffers buffers = new SimpleBuffers(WebSocketClientFactory.this._buffers.getBuffer(), null);
            this._parser = new HttpParser(buffers, this._endp, new HttpParser.EventHandler(){

                @Override
                public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
                    if (status != 101) {
                        HandshakeConnection.this._error = "Bad response status " + status + " " + reason;
                        HandshakeConnection.this._endp.close();
                    }
                }

                @Override
                public void parsedHeader(Buffer name, Buffer value) throws IOException {
                    if (__ACCEPT.equals(name)) {
                        HandshakeConnection.this._accept = value.toString();
                    }
                }

                @Override
                public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
                    if (HandshakeConnection.this._error == null) {
                        HandshakeConnection.this._error = "Bad response: " + method + " " + url + " " + version;
                    }
                    HandshakeConnection.this._endp.close();
                }

                @Override
                public void content(Buffer ref) throws IOException {
                    if (HandshakeConnection.this._error == null) {
                        HandshakeConnection.this._error = "Bad response. " + ref.length() + "B of content?";
                    }
                    HandshakeConnection.this._endp.close();
                }
            });
            String path = this._future.getURI().getPath();
            if (path == null || path.length() == 0) {
                path = "/";
            }
            if (this._future.getURI().getRawQuery() != null) {
                path = path + "?" + this._future.getURI().getRawQuery();
            }
            String origin = future.getOrigin();
            StringBuilder request = new StringBuilder(512);
            request.append("GET ").append(path).append(" HTTP/1.1\r\n").append("Host: ").append(future.getURI().getHost()).append(":").append(this._future.getURI().getPort()).append("\r\n").append("Upgrade: websocket\r\n").append("Connection: Upgrade\r\n").append("Sec-WebSocket-Key: ").append(this._key).append("\r\n");
            if (origin != null) {
                request.append("Origin: ").append(origin).append("\r\n");
            }
            request.append("Sec-WebSocket-Version: ").append(13).append("\r\n");
            if (future.getProtocol() != null) {
                request.append("Sec-WebSocket-Protocol: ").append(future.getProtocol()).append("\r\n");
            }
            if (future.getCookies() != null && future.getCookies().size() > 0) {
                for (String cookie : future.getCookies().keySet()) {
                    request.append("Cookie: ").append(QuotedStringTokenizer.quoteIfNeeded(cookie, "\"\\\n\r\t\f\b%+ ;=")).append("=").append(QuotedStringTokenizer.quoteIfNeeded(future.getCookies().get(cookie), "\"\\\n\r\t\f\b%+ ;=")).append("\r\n");
                }
            }
            request.append("\r\n");
            try {
                ByteArrayBuffer handshake = new ByteArrayBuffer(request.toString(), false);
                int len = handshake.length();
                if (len != this._endp.flush(handshake)) {
                    throw new IOException("incomplete");
                }
            }
            catch (IOException e) {
                future.handshakeFailed(e);
            }
        }

        @Override
        public Connection handle() throws IOException {
            while (this._endp.isOpen() && !this._parser.isComplete()) {
                if (this._parser.parseAvailable()) continue;
                if (this._endp.isInputShutdown()) {
                    this._future.handshakeFailed(new IOException("Incomplete handshake response"));
                }
                return this;
            }
            if (this._error == null) {
                if (this._accept == null) {
                    this._error = "No Sec-WebSocket-Accept";
                } else if (!WebSocketConnectionD13.hashKey(this._key).equals(this._accept)) {
                    this._error = "Bad Sec-WebSocket-Accept";
                } else {
                    Buffer header = this._parser.getHeaderBuffer();
                    MaskGen maskGen = this._future.getMaskGen();
                    WebSocketConnectionD13 connection = new WebSocketConnectionD13(this._future.getWebSocket(), this._endp, WebSocketClientFactory.this._buffers, System.currentTimeMillis(), this._future.getMaxIdleTime(), this._future.getProtocol(), null, 13, maskGen);
                    if (header.hasContent()) {
                        connection.fillBuffersFrom(header);
                    }
                    WebSocketClientFactory.this._buffers.returnBuffer(header);
                    this._future.onConnection(connection);
                    return connection;
                }
            }
            this._endp.close();
            return this;
        }

        @Override
        public void onInputShutdown() throws IOException {
            this._endp.close();
        }

        @Override
        public boolean isIdle() {
            return false;
        }

        @Override
        public boolean isSuspended() {
            return false;
        }

        @Override
        public void onClose() {
            if (this._error != null) {
                this._future.handshakeFailed(new ProtocolException(this._error));
            } else {
                this._future.handshakeFailed(new EOFException());
            }
        }

        @Override
        public String toString() {
            return "HS" + super.toString();
        }
    }

    class WebSocketClientSelector
    extends SelectorManager {
        WebSocketClientSelector() {
        }

        @Override
        public boolean dispatch(Runnable task) {
            return WebSocketClientFactory.this._threadPool.dispatch(task);
        }

        @Override
        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            SelectChannelEndPoint endp = new SelectChannelEndPoint(channel, selectSet, key, channel.socket().getSoTimeout());
            endp.setConnection(selectSet.getManager().newConnection(channel, endp, key.attachment()));
            return endp;
        }

        @Override
        public AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint, Object attachment) {
            WebSocketClient.WebSocketFuture holder = (WebSocketClient.WebSocketFuture)attachment;
            return new HandshakeConnection(endpoint, holder);
        }

        @Override
        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        @Override
        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
            LOG.debug("upgrade {} -> {}", oldConnection, endpoint.getConnection());
        }

        @Override
        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            endpoint.getConnection().onClose();
        }

        @Override
        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            if (!(attachment instanceof WebSocketClient.WebSocketFuture)) {
                super.connectionFailed(channel, ex, attachment);
            } else {
                __log.debug(ex);
                WebSocketClient.WebSocketFuture future = (WebSocketClient.WebSocketFuture)attachment;
                future.handshakeFailed(ex);
            }
        }
    }
}

