/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.security.jaspi;

import jakarta.security.auth.message.MessageInfo;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class JaspiMessageInfo
implements MessageInfo {
    public static final String AUTHENTICATION_TYPE_KEY = "jakarta.servlet.http.authType";
    private final Callback _callback;
    private Request _request;
    private Response _response;
    private final MIMap _map;

    public JaspiMessageInfo(Request request, Response response, Callback callback) {
        this._request = request;
        this._response = response;
        this._callback = callback;
        this._map = new MIMap();
    }

    public Callback getCallback() {
        return this._callback;
    }

    public Map getMap() {
        return this._map;
    }

    public Request getBaseRequest() {
        return this._request;
    }

    public Response getBaseResponse() {
        return this._response;
    }

    public Object getRequestMessage() {
        if (this._request == null) {
            return null;
        }
        return ((ServletContextRequest)Request.as((Request)this._request, ServletContextRequest.class)).getServletApiRequest();
    }

    public Object getResponseMessage() {
        if (this._response == null) {
            return null;
        }
        return ((ServletContextResponse)Response.as((Response)this._response, ServletContextResponse.class)).getServletApiResponse();
    }

    public void setRequestMessage(Object request) {
        if (!(request instanceof ServletRequest)) {
            throw new IllegalStateException("Not a ServletRequest");
        }
        this._request = ServletContextRequest.getServletContextRequest((ServletRequest)((ServletRequest)request));
    }

    public void setResponseMessage(Object response) {
        if (!(response instanceof ServletResponse)) {
            throw new IllegalStateException("Not a ServletResponse");
        }
        this._response = ServletContextResponse.getServletContextResponse((ServletResponse)((ServletResponse)response));
    }

    private static class MIMap
    implements Map {
        private String authenticationType;
        private Map delegate;

        private MIMap() {
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate == null || this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (JaspiMessageInfo.AUTHENTICATION_TYPE_KEY.equals(key)) {
                return this.authenticationType != null;
            }
            return this.delegate != null && this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (this.authenticationType == value || this.authenticationType != null && this.authenticationType.equals(value)) {
                return true;
            }
            return this.delegate != null && this.delegate.containsValue(value);
        }

        public Object get(Object key) {
            if (JaspiMessageInfo.AUTHENTICATION_TYPE_KEY.equals(key)) {
                return this.authenticationType;
            }
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.get(key);
        }

        public Object put(Object key, Object value) {
            if (JaspiMessageInfo.AUTHENTICATION_TYPE_KEY.equals(key)) {
                String authenticationType = this.authenticationType;
                this.authenticationType = (String)value;
                if (this.delegate != null) {
                    this.delegate.put(JaspiMessageInfo.AUTHENTICATION_TYPE_KEY, value);
                }
                return authenticationType;
            }
            return this.getDelegate(true).put(key, value);
        }

        public Object remove(Object key) {
            if (JaspiMessageInfo.AUTHENTICATION_TYPE_KEY.equals(key)) {
                String authenticationType = this.authenticationType;
                this.authenticationType = null;
                if (this.delegate != null) {
                    this.delegate.remove(JaspiMessageInfo.AUTHENTICATION_TYPE_KEY);
                }
                return authenticationType;
            }
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.remove(key);
        }

        public void putAll(Map map) {
            if (map != null) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }

        @Override
        public void clear() {
            this.authenticationType = null;
            this.delegate = null;
        }

        public Set keySet() {
            return this.getDelegate(true).keySet();
        }

        public Collection values() {
            return this.getDelegate(true).values();
        }

        public Set entrySet() {
            return this.getDelegate(true).entrySet();
        }

        private Map getDelegate(boolean create) {
            if (!create || this.delegate != null) {
                return this.delegate;
            }
            if (create) {
                this.delegate = new HashMap();
                if (this.authenticationType != null) {
                    this.delegate.put(JaspiMessageInfo.AUTHENTICATION_TYPE_KEY, this.authenticationType);
                }
            }
            return this.delegate;
        }

        String getAuthenticationType() {
            return this.authenticationType;
        }
    }
}

