/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.common;

import jakarta.websocket.Extension;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketExtension;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketFrameHandler;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketSessionListener;
import org.eclipse.jetty.ee10.websocket.jakarta.common.SessionTracker;
import org.eclipse.jetty.ee10.websocket.jakarta.common.UpgradeRequest;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JakartaWebSocketContainer
extends ContainerLifeCycle
implements WebSocketContainer,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketContainer.class);
    private final List<JakartaWebSocketSessionListener> sessionListeners = new ArrayList<JakartaWebSocketSessionListener>();
    protected final SessionTracker sessionTracker = new SessionTracker();
    protected final Configuration.ConfigurationCustomizer defaultCustomizer = new Configuration.ConfigurationCustomizer();
    protected final WebSocketComponents components;

    public JakartaWebSocketContainer(WebSocketComponents components) {
        this.components = components;
        this.addSessionListener(this.sessionTracker);
        this.addBean(this.sessionTracker);
    }

    public abstract Executor getExecutor();

    protected abstract JakartaWebSocketFrameHandlerFactory getFrameHandlerFactory();

    public ByteBufferPool getByteBufferPool() {
        return this.components.getByteBufferPool();
    }

    public WebSocketExtensionRegistry getExtensionRegistry() {
        return this.components.getExtensionRegistry();
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.components.getObjectFactory();
    }

    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultCustomizer.getWriteTimeout().toMillis();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        long max = this.defaultCustomizer.getMaxBinaryMessageSize();
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultCustomizer.getIdleTimeout().toMillis();
    }

    public int getDefaultMaxTextMessageBufferSize() {
        long max = this.defaultCustomizer.getMaxTextMessageSize();
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public void setAsyncSendTimeout(long ms) {
        this.defaultCustomizer.setWriteTimeout(Duration.ofMillis(ms));
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.defaultCustomizer.setMaxBinaryMessageSize((long)max);
    }

    public void setDefaultMaxSessionIdleTimeout(long ms) {
        this.defaultCustomizer.setIdleTimeout(Duration.ofMillis(ms));
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.defaultCustomizer.setMaxTextMessageSize((long)max);
    }

    public Set<Extension> getInstalledExtensions() {
        HashSet<Extension> ret = new HashSet<Extension>();
        for (String name : this.getExtensionRegistry().getAvailableExtensionNames()) {
            ret.add(new JakartaWebSocketExtension(name));
        }
        return ret;
    }

    public Set<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    public JakartaWebSocketFrameHandler newFrameHandler(Object websocketPojo, UpgradeRequest upgradeRequest) {
        return this.getFrameHandlerFactory().newJakartaWebSocketFrameHandler(websocketPojo, upgradeRequest);
    }

    public void addSessionListener(JakartaWebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(JakartaWebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void notifySessionListeners(Consumer<JakartaWebSocketSessionListener> consumer) {
        for (JakartaWebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)x);
            }
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{this.defaultCustomizer});
    }
}

