/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport.internal;

import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.transport.internal.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.client.transport.internal.HttpReceiverOverHTTP2;
import org.eclipse.jetty.http2.client.transport.internal.HttpSenderOverHTTP2;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverHTTP2
extends HttpChannel {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverHTTP2.class);
    private final Stream.Listener listener = new Listener();
    private final HttpConnectionOverHTTP2 connection;
    private final Session session;
    private final HttpSenderOverHTTP2 sender;
    private final HttpReceiverOverHTTP2 receiver;
    private Stream stream;

    public HttpChannelOverHTTP2(HttpConnectionOverHTTP2 connection, Session session) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.session = session;
        this.sender = new HttpSenderOverHTTP2(this);
        this.receiver = new HttpReceiverOverHTTP2(this);
    }

    protected HttpConnectionOverHTTP2 getHttpConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public Stream.Listener getStreamListener() {
        return this.listener;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected HttpSender getHttpSender() {
        return this.sender;
    }

    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
        if (stream != null) {
            ((HTTP2Stream)stream).setAttachment((Object)this.receiver);
        }
    }

    public boolean isFailed() {
        return this.sender.isFailed() || this.receiver.isFailed();
    }

    public void send(HttpExchange exchange) {
        this.sender.send(exchange);
    }

    public void release() {
        this.setStream(null);
        boolean released = this.connection.release(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("released channel? {} {}", (Object)released, (Object)this);
        }
        if (released) {
            this.getHttpDestination().release((Connection)this.getHttpConnection());
        }
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        Stream stream = this.getStream();
        if (LOG.isDebugEnabled()) {
            LOG.debug("exchange terminated {} {}", (Object)result, (Object)stream);
        }
        if (result.isSucceeded()) {
            this.release();
        } else if (stream != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), (Callback)new ReleaseCallback());
        } else {
            this.release();
        }
    }

    public String toString() {
        return String.format("%s[send=%s,recv=%s]", new Object[]{super.toString(), this.sender, this.receiver});
    }

    private class Listener
    implements Stream.Listener {
        private Listener() {
        }

        public void onNewStream(Stream stream) {
            HttpChannelOverHTTP2.this.setStream(stream);
        }

        public void onHeaders(Stream stream, HeadersFrame frame) {
            HttpChannelOverHTTP2.this.receiver.onHeaders(stream, frame);
        }

        public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
            return HttpChannelOverHTTP2.this.receiver.onPush(stream, frame);
        }

        public void onDataAvailable(Stream stream) {
            HTTP2Channel.Client channel = (HTTP2Channel.Client)((HTTP2Stream)stream).getAttachment();
            channel.onDataAvailable();
        }

        public void onReset(Stream stream, ResetFrame frame, Callback callback) {
            HttpChannelOverHTTP2.this.receiver.onReset(frame);
            callback.succeeded();
        }

        public void onIdleTimeout(Stream stream, TimeoutException x, Promise<Boolean> promise) {
            HTTP2Channel.Client channel = (HTTP2Channel.Client)((HTTP2Stream)stream).getAttachment();
            channel.onTimeout(x, promise);
        }

        public void onFailure(Stream stream, int error, String reason, Throwable failure, Callback callback) {
            HTTP2Channel.Client channel = (HTTP2Channel.Client)((HTTP2Stream)stream).getAttachment();
            channel.onFailure(failure, callback);
        }
    }

    private class ReleaseCallback
    implements Callback {
        private ReleaseCallback() {
        }

        public void succeeded() {
            HttpChannelOverHTTP2.this.release();
        }

        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ReleaseCallback failed", x);
            }
            HttpChannelOverHTTP2.this.release();
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }
}

