/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport.internal;

import java.io.EOFException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.transport.internal.HttpChannelOverHTTP3;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverOverHTTP3
extends HttpReceiver
implements Stream.Client.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiverOverHTTP3.class);

    protected HttpReceiverOverHTTP3(HttpChannelOverHTTP3 channel) {
        super((HttpChannel)channel);
    }

    protected void onInterim() {
    }

    public Content.Chunk read(boolean fillInterestIfNeeded) {
        boolean last;
        Stream stream = this.getHttpChannel().getStream();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading, fillInterestIfNeeded={} from {} in {}", new Object[]{fillInterestIfNeeded, stream, this});
        }
        if (stream == null) {
            return Content.Chunk.from((Throwable)new EOFException("Channel has been released"));
        }
        Stream.Data data = stream.readData();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read stream data {} in {}", (Object)data, (Object)this);
        }
        if (data == null) {
            if (fillInterestIfNeeded) {
                stream.demand();
            }
            return null;
        }
        ByteBuffer byteBuffer = data.getByteBuffer();
        boolean bl = last = !byteBuffer.hasRemaining() && data.isLast();
        if (!last) {
            return Content.Chunk.asChunk((ByteBuffer)byteBuffer, (boolean)last, (Retainable)data);
        }
        data.release();
        this.responseSuccess(this.getHttpExchange(), null);
        return Content.Chunk.EOF;
    }

    public void failAndClose(Throwable failure) {
        Stream stream = this.getHttpChannel().getStream();
        this.responseFailure(failure, Promise.from(failed -> {
            if (failed.booleanValue()) {
                stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), failure);
            }
        }, x -> stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), failure)));
    }

    protected HttpChannelOverHTTP3 getHttpChannel() {
        return (HttpChannelOverHTTP3)super.getHttpChannel();
    }

    public void onNewStream(Stream.Client stream) {
        this.getHttpChannel().setStream((Stream)stream);
    }

    public void onResponse(Stream.Client stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse httpResponse = exchange.getResponse();
        MetaData.Response response = (MetaData.Response)frame.getMetaData();
        httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
        this.responseBegin(exchange);
        HttpFields headers = response.getHttpFields();
        for (HttpField header : headers) {
            this.responseHeader(exchange, header);
        }
        this.responseHeaders(exchange);
    }

    public void onDataAvailable(Stream.Client stream) {
        HttpExchange exchange;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data available notification in {}", (Object)this);
        }
        if ((exchange = this.getHttpExchange()) == null) {
            return;
        }
        this.responseContentAvailable(exchange);
    }

    public void onTrailer(Stream.Client stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpFields trailers = frame.getMetaData().getHttpFields();
        trailers.forEach(arg_0 -> ((HttpResponse)exchange.getResponse()).trailer(arg_0));
        this.responseSuccess(exchange, null);
    }

    public void onIdleTimeout(Stream.Client stream, Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            exchange.abort(failure, Promise.from(aborted -> promise.succeeded((Object)(aborted == false ? 1 : 0)), arg_0 -> promise.failed(arg_0)));
        } else {
            promise.succeeded((Object)false);
        }
    }

    public void onFailure(Stream.Client stream, long error, Throwable failure) {
        this.responseFailure(failure, Promise.noop());
    }
}

