/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.net.SocketAddress;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.quic.client.ClientQuicConfiguration;
import org.eclipse.jetty.quic.client.QuicTransport;
import org.eclipse.jetty.quic.common.QuicSessionContainer;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3Client
extends ContainerLifeCycle {
    public static final String CLIENT_CONTEXT_KEY = HTTP3Client.class.getName();
    public static final String SESSION_LISTENER_CONTEXT_KEY = CLIENT_CONTEXT_KEY + ".listener";
    public static final String SESSION_PROMISE_CONTEXT_KEY = CLIENT_CONTEXT_KEY + ".promise";
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Client.class);
    private final QuicSessionContainer container = new QuicSessionContainer();
    private final HTTP3Configuration http3Configuration = new HTTP3Configuration();
    private final ClientQuicConfiguration quicConfiguration;
    private final ClientConnector connector;

    public HTTP3Client(ClientQuicConfiguration quicConfiguration) {
        this(quicConfiguration, new ClientConnector());
    }

    public HTTP3Client(ClientQuicConfiguration quicConfiguration, ClientConnector connector) {
        this.quicConfiguration = quicConfiguration;
        this.connector = connector;
        this.addBean(connector);
        connector.setSslContextFactory(quicConfiguration.getSslContextFactory());
        quicConfiguration.setMaxUnidirectionalRemoteStreams(48);
        quicConfiguration.setUnidirectionalStreamRecvWindow(0x400000);
        quicConfiguration.setProtocols(List.of("h3"));
    }

    public ClientConnector getClientConnector() {
        return this.connector;
    }

    public ClientQuicConfiguration getQuicConfiguration() {
        return this.quicConfiguration;
    }

    public HTTP3Configuration getHTTP3Configuration() {
        return this.http3Configuration;
    }

    protected void doStart() throws Exception {
        LOG.info("HTTP/3+QUIC support is experimental and not suited for production use.");
        this.addBean(this.quicConfiguration);
        this.addBean(this.container);
        this.addBean(this.http3Configuration);
        this.quicConfiguration.addEventListener((EventListener)this.container);
        super.doStart();
    }

    public CompletableFuture<Session.Client> connect(SocketAddress socketAddress, Session.Client.Listener listener) {
        ConcurrentHashMap<String, Object> context = new ConcurrentHashMap<String, Object>();
        return this.connect(socketAddress, listener, context);
    }

    public CompletableFuture<Session.Client> connect(SocketAddress socketAddress, Session.Client.Listener listener, Map<String, Object> context) {
        if (context == null) {
            context = new ConcurrentHashMap<String, Object>();
        }
        return this.connect((Transport)new QuicTransport(this.getQuicConfiguration()), socketAddress, listener, context);
    }

    public CompletableFuture<Session.Client> connect(Transport transport, SocketAddress socketAddress, Session.Client.Listener listener, Map<String, Object> context) {
        if (context == null) {
            context = new ConcurrentHashMap<String, Object>();
        }
        Promise.Completable completable = new Promise.Completable();
        context.put(CLIENT_CONTEXT_KEY, (Object)this);
        context.put(SESSION_LISTENER_CONTEXT_KEY, listener);
        context.put(SESSION_PROMISE_CONTEXT_KEY, completable);
        context.putIfAbsent("org.eclipse.jetty.client.connector", this.connector);
        context.computeIfAbsent("org.eclipse.jetty.client.connector.clientConnectionFactory", key -> new HTTP3ClientConnectionFactory());
        context.put("org.eclipse.jetty.client.connector.connectionPromise", Promise.from(ioConnection -> {}, arg_0 -> ((Promise.Completable)completable).failed(arg_0)));
        context.put(Transport.class.getName(), transport);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to {}", (Object)socketAddress);
        }
        transport.connect(socketAddress, context);
        return completable;
    }

    public CompletableFuture<Void> shutdown() {
        return this.container.shutdown();
    }
}

