/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jetty.maven.OverlayConfig;
import org.eclipse.jetty.util.StringUtil;

public class WarPluginInfo {
    private MavenProject _project;
    private Plugin _plugin;
    private List<String> _dependentMavenWarIncludes;
    private List<String> _dependentMavenWarExcludes;
    private List<OverlayConfig> _overlayConfigs;
    private Set<Artifact> _warArtifacts;

    public WarPluginInfo(MavenProject project) {
        this._project = project;
        this._warArtifacts = this._project.getArtifacts() != null ? this._project.getArtifacts().stream().filter(a -> "war".equals(a.getType()) || "zip".equals(a.getType())).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public MavenProject getProject() {
        return this._project;
    }

    public Set<Artifact> getWarArtifacts() {
        return this._warArtifacts;
    }

    public Artifact getWarArtifact(String groupId, String artifactId, String classifier) {
        Optional<Artifact> o = this._warArtifacts.stream().filter(a -> this.match((Artifact)a, groupId, artifactId, classifier)).findFirst();
        return o.orElse(null);
    }

    public Plugin getWarPlugin() {
        if (this._plugin == null) {
            List plugins = this._project.getBuildPlugins();
            if (plugins == null) {
                return null;
            }
            for (Plugin p : plugins) {
                if (!"maven-war-plugin".equals(p.getArtifactId())) continue;
                this._plugin = p;
                break;
            }
        }
        return this._plugin;
    }

    public List<String> getDependentMavenWarIncludes() {
        if (this._dependentMavenWarIncludes == null) {
            this.getWarPlugin();
            if (this._plugin == null) {
                return null;
            }
            Xpp3Dom node = (Xpp3Dom)this._plugin.getConfiguration();
            if (node == null) {
                return null;
            }
            if ((node = node.getChild("dependentWarIncludes")) == null) {
                return null;
            }
            String val = node.getValue();
            this._dependentMavenWarIncludes = StringUtil.csvSplit(null, (String)val, (int)0, (int)val.length());
        }
        return this._dependentMavenWarIncludes;
    }

    public List<String> getDependentMavenWarExcludes() {
        if (this._dependentMavenWarExcludes == null) {
            this.getWarPlugin();
            if (this._plugin == null) {
                return null;
            }
            Xpp3Dom node = (Xpp3Dom)this._plugin.getConfiguration();
            if (node == null) {
                return null;
            }
            if ((node = node.getChild("dependentWarExcludes")) == null) {
                return null;
            }
            String val = node.getValue();
            this._dependentMavenWarExcludes = StringUtil.csvSplit(null, (String)val, (int)0, (int)val.length());
        }
        return this._dependentMavenWarExcludes;
    }

    public List<OverlayConfig> getMavenWarOverlayConfigs() {
        if (this._overlayConfigs == null) {
            this.getWarPlugin();
            if (this._plugin == null) {
                return Collections.emptyList();
            }
            this.getDependentMavenWarIncludes();
            this.getDependentMavenWarExcludes();
            Xpp3Dom node = (Xpp3Dom)this._plugin.getConfiguration();
            if (node == null) {
                return Collections.emptyList();
            }
            if ((node = node.getChild("overlays")) == null) {
                return Collections.emptyList();
            }
            Xpp3Dom[] nodes = node.getChildren("overlay");
            if (nodes == null) {
                return Collections.emptyList();
            }
            this._overlayConfigs = new ArrayList<OverlayConfig>();
            for (int i = 0; i < nodes.length; ++i) {
                OverlayConfig overlayConfig = new OverlayConfig(nodes[i], this._dependentMavenWarIncludes, this._dependentMavenWarExcludes);
                this._overlayConfigs.add(overlayConfig);
            }
        }
        return this._overlayConfigs;
    }

    public boolean match(Artifact a, String gid, String aid, String cls) {
        if (a == null) {
            return gid == null && aid == null && cls == null;
        }
        return (a.getGroupId() == null && gid == null || a.getGroupId() != null && a.getGroupId().equals(gid)) && (a.getArtifactId() == null && aid == null || a.getArtifactId() != null && a.getArtifactId().equals(aid)) && (a.getClassifier() == null || a.getClassifier().equals(cls));
    }

    public boolean match(Artifact a, String gid, String aid) {
        if (a == null) {
            return gid == null && aid == null;
        }
        return (a.getGroupId() == null && gid == null || a.getGroupId() != null && a.getGroupId().equals(gid)) && (a.getArtifactId() == null && aid == null || a.getArtifactId() != null && a.getArtifactId().equals(aid));
    }
}

