/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdConfiguration
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdConfiguration.class);
    private static final String CONFIG_PATH = "/.well-known/openid-configuration";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String TOKEN_ENDPOINT = "token_endpoint";
    private static final String END_SESSION_ENDPOINT = "end_session_endpoint";
    private static final String ISSUER = "issuer";
    private final HttpClient httpClient;
    private final String issuer;
    private final String clientId;
    private final String clientSecret;
    private final List<String> scopes = new ArrayList<String>();
    private final String authenticationMethod;
    private String authEndpoint;
    private String tokenEndpoint;
    private String endSessionEndpoint;
    private boolean authenticateNewUsers = false;
    private boolean logoutWhenIdTokenIsExpired = false;

    public OpenIdConfiguration(String provider, String clientId, String clientSecret) {
        this(provider, null, null, clientId, clientSecret, null);
    }

    public OpenIdConfiguration(String issuer, String authorizationEndpoint, String tokenEndpoint, String clientId, String clientSecret, HttpClient httpClient) {
        this(issuer, authorizationEndpoint, tokenEndpoint, clientId, clientSecret, "client_secret_post", httpClient);
    }

    public OpenIdConfiguration(@Name(value="issuer") String issuer, @Name(value="authorizationEndpoint") String authorizationEndpoint, @Name(value="tokenEndpoint") String tokenEndpoint, @Name(value="clientId") String clientId, @Name(value="clientSecret") String clientSecret, @Name(value="authenticationMethod") String authenticationMethod, @Name(value="httpClient") HttpClient httpClient) {
        this(issuer, authorizationEndpoint, tokenEndpoint, null, clientId, clientSecret, authenticationMethod, httpClient);
    }

    public OpenIdConfiguration(@Name(value="issuer") String issuer, @Name(value="authorizationEndpoint") String authorizationEndpoint, @Name(value="tokenEndpoint") String tokenEndpoint, @Name(value="endSessionEndpoint") String endSessionEndpoint, @Name(value="clientId") String clientId, @Name(value="clientSecret") String clientSecret, @Name(value="authenticationMethod") String authenticationMethod, @Name(value="httpClient") HttpClient httpClient) {
        this.issuer = issuer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authEndpoint = authorizationEndpoint;
        this.endSessionEndpoint = endSessionEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.httpClient = httpClient != null ? httpClient : OpenIdConfiguration.newHttpClient();
        String string = this.authenticationMethod = authenticationMethod == null ? "client_secret_post" : authenticationMethod;
        if (this.issuer == null) {
            throw new IllegalArgumentException("Issuer was not configured");
        }
        this.addBean(this.httpClient);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.authEndpoint == null || this.tokenEndpoint == null) {
            Map<String, Object> discoveryDocument = this.fetchOpenIdConnectMetadata();
            this.processMetadata(discoveryDocument);
        }
    }

    protected void processMetadata(Map<String, Object> discoveryDocument) {
        this.authEndpoint = (String)discoveryDocument.get(AUTHORIZATION_ENDPOINT);
        if (this.authEndpoint == null) {
            throw new IllegalStateException(AUTHORIZATION_ENDPOINT);
        }
        this.tokenEndpoint = (String)discoveryDocument.get(TOKEN_ENDPOINT);
        if (this.tokenEndpoint == null) {
            throw new IllegalStateException(TOKEN_ENDPOINT);
        }
        if (this.endSessionEndpoint == null) {
            this.endSessionEndpoint = (String)discoveryDocument.get(END_SESSION_ENDPOINT);
        }
        if (!Objects.equals(discoveryDocument.get(ISSUER), this.issuer)) {
            LOG.warn("The issuer in the metadata is not correct.");
        }
    }

    protected Map<String, Object> fetchOpenIdConnectMetadata() {
        String provider = this.issuer;
        if (provider.endsWith("/")) {
            provider = provider.substring(0, provider.length() - 1);
        }
        try {
            String responseBody = this.httpClient.GET(provider + CONFIG_PATH).getContentAsString();
            Object parsedResult = new JSON().fromJSON(responseBody);
            if (parsedResult instanceof Map) {
                Map rawResult = (Map)parsedResult;
                Map<String, Object> result = rawResult.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(it -> it.getKey().toString(), Map.Entry::getValue));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("discovery document {}", result);
                }
                return result;
            }
            LOG.warn("OpenID provider did not return a proper JSON object response. Result was '{}'", (Object)responseBody);
            throw new IllegalStateException("Could not parse OpenID provider's malformed response");
        }
        catch (Exception e) {
            throw new IllegalStateException("invalid identity provider " + provider, e);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void addScopes(String ... scopes) {
        if (scopes != null) {
            Collections.addAll(this.scopes, scopes);
        }
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean isAuthenticateNewUsers() {
        return this.authenticateNewUsers;
    }

    public void setAuthenticateNewUsers(boolean authenticateNewUsers) {
        this.authenticateNewUsers = authenticateNewUsers;
    }

    public boolean isLogoutWhenIdTokenIsExpired() {
        return this.logoutWhenIdTokenIsExpired;
    }

    public void setLogoutWhenIdTokenIsExpired(boolean logoutWhenIdTokenIsExpired) {
        this.logoutWhenIdTokenIsExpired = logoutWhenIdTokenIsExpired;
    }

    private static HttpClient newHttpClient() {
        ClientConnector connector = new ClientConnector();
        connector.setSslContextFactory(new SslContextFactory.Client(false));
        return new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(connector));
    }

    public String toString() {
        return String.format("%s@%x{iss=%s, clientId=%s, authEndpoint=%s, authenticator=%s, tokenEndpoint=%s, scopes=%s, authNewUsers=%s}", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.issuer, this.clientId, this.authEndpoint, this.authenticationMethod, this.tokenEndpoint, this.scopes, this.authenticateNewUsers);
    }
}

