/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowedResourceAliasChecker
extends AbstractLifeCycle
implements AliasCheck {
    private static final Logger LOG = LoggerFactory.getLogger(AllowedResourceAliasChecker.class);
    protected static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
    protected static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private final ContextHandler _contextHandler;
    private final Supplier<Resource> _resourceBaseSupplier;
    private final List<String> _protected = new ArrayList<String>();
    private final AllowedResourceAliasCheckListener _listener = new AllowedResourceAliasCheckListener();
    private boolean _initialized;
    protected Resource _baseResource;
    @Deprecated
    protected Path _base;

    public AllowedResourceAliasChecker(ContextHandler contextHandler) {
        this(contextHandler, contextHandler::getBaseResource);
    }

    public AllowedResourceAliasChecker(ContextHandler contextHandler, Resource baseResource) {
        this(contextHandler, () -> baseResource);
    }

    public AllowedResourceAliasChecker(ContextHandler contextHandler, Supplier<Resource> resourceBaseSupplier) {
        this._contextHandler = Objects.requireNonNull(contextHandler);
        this._resourceBaseSupplier = Objects.requireNonNull(resourceBaseSupplier);
    }

    protected ContextHandler getContextHandler() {
        return this._contextHandler;
    }

    private String[] getProtectedTargets() {
        return this._contextHandler.getProtectedTargets();
    }

    private void extractBaseResourceFromContext() {
        this._baseResource = this._resourceBaseSupplier.get();
        if (this._baseResource == null) {
            return;
        }
        try {
            String[] protectedTargets = this.getProtectedTargets();
            if (protectedTargets != null) {
                this._protected.addAll(Arrays.asList(protectedTargets));
            }
        }
        catch (Throwable t) {
            LOG.warn("Base resource failure ({} is disabled): {}", new Object[]{this.getClass().getName(), this._baseResource, t});
            this._baseResource = null;
        }
    }

    protected void initialize() {
        this.extractBaseResourceFromContext();
        this._initialized = true;
    }

    protected void doStart() throws Exception {
        if (this._contextHandler.isStarted()) {
            this.initialize();
        } else {
            this._contextHandler.addEventListener((EventListener)((Object)this._listener));
        }
    }

    protected void doStop() throws Exception {
        this._contextHandler.removeEventListener((EventListener)((Object)this._listener));
        this._baseResource = null;
        this._protected.clear();
    }

    @Override
    public boolean checkAlias(String pathInContext, Resource resource) {
        if (!this._initialized) {
            this.extractBaseResourceFromContext();
        }
        if (this._baseResource == null) {
            return false;
        }
        try {
            if (!resource.exists()) {
                return false;
            }
            return this.check(pathInContext, resource);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to check alias", t);
            }
            return false;
        }
    }

    protected boolean check(String pathInContext, Path path) {
        return this.isAllowed(AllowedResourceAliasChecker.getRealPath(path));
    }

    protected boolean check(String pathInContext, Resource resource) {
        for (Resource r : resource) {
            if (this.check(pathInContext, r.getPath())) continue;
            return false;
        }
        return true;
    }

    protected boolean isAllowed(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            while (path != null) {
                if (this._baseResource.isSameFile(path)) {
                    return true;
                }
                for (String protectedTarget : this._protected) {
                    Resource p = this._baseResource.resolve(protectedTarget);
                    if (p == null) continue;
                    for (Resource r : p) {
                        if (!r.isSameFile(path)) continue;
                        return false;
                    }
                }
                path = path.getParent();
            }
        }
        return false;
    }

    @Deprecated
    protected boolean isSameFile(Path path1, Path path2) {
        block4: {
            if (Objects.equals(path1, path2)) {
                return true;
            }
            try {
                if (Files.isSameFile(path1, path2)) {
                    return true;
                }
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", t);
            }
        }
        return false;
    }

    private static Path getRealPath(Path path) {
        block4: {
            if (path == null || !Files.exists(path, new LinkOption[0])) {
                return null;
            }
            try {
                path = path.toRealPath(FOLLOW_LINKS);
                if (Files.exists(path, new LinkOption[0])) {
                    return path;
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("No real path for {}", (Object)path, (Object)e);
            }
        }
        return null;
    }

    @Deprecated
    protected Path getPath(Resource resource) {
        return null;
    }

    public String toString() {
        String[] protectedTargets = this.getProtectedTargets();
        return String.format("%s@%x{base=%s,protected=%s}", this.getClass().getSimpleName(), this.hashCode(), this._baseResource, protectedTargets == null ? null : Arrays.asList(protectedTargets));
    }

    private class AllowedResourceAliasCheckListener
    implements LifeCycle.Listener {
        private AllowedResourceAliasCheckListener() {
        }

        public void lifeCycleStarted(LifeCycle event) {
            AllowedResourceAliasChecker.this.initialize();
        }
    }
}

