/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.foreign.NativeHelper;
import org.eclipse.jetty.quic.quiche.foreign.quiche_h;
import org.eclipse.jetty.quic.quiche.foreign.quiche_path_stats;
import org.eclipse.jetty.quic.quiche.foreign.quiche_recv_info;
import org.eclipse.jetty.quic.quiche.foreign.quiche_send_info;
import org.eclipse.jetty.quic.quiche.foreign.quiche_transport_params;
import org.eclipse.jetty.quic.quiche.foreign.sockaddr;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignQuicheConnection
extends QuicheConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignQuicheConnection.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final AutoLock lock = new AutoLock();
    private MemorySegment quicheConn;
    private MemorySegment quicheConfig;
    private Arena scope;
    private MemorySegment sendInfo;
    private MemorySegment recvInfo;
    private MemorySegment transportParams;
    private MemorySegment pathStats;

    private ForeignQuicheConnection(MemorySegment quicheConn, MemorySegment quicheConfig, Arena scope) {
        this.quicheConn = quicheConn;
        this.quicheConfig = quicheConfig;
        this.scope = scope;
        this.sendInfo = quiche_send_info.allocate(scope);
        this.recvInfo = quiche_recv_info.allocate(scope);
        this.transportParams = quiche_transport_params.allocate(scope);
        this.pathStats = quiche_path_stats.allocate(scope);
    }

    public static byte[] fromPacket(ByteBuffer packet) {
        try (Arena scope = Arena.ofConfined();){
            int rc;
            MemorySegment packetReadSegment;
            MemorySegment type = scope.allocate(NativeHelper.C_CHAR);
            MemorySegment version = scope.allocate(NativeHelper.C_INT);
            MemorySegment scid = scope.allocate(20L);
            MemorySegment scid_len = scope.allocate(NativeHelper.C_LONG);
            scid_len.set(NativeHelper.C_LONG, 0L, scid.byteSize());
            MemorySegment dcid = scope.allocate(20L);
            MemorySegment dcid_len = scope.allocate(NativeHelper.C_LONG);
            dcid_len.set(NativeHelper.C_LONG, 0L, dcid.byteSize());
            MemorySegment token = scope.allocate(48L);
            MemorySegment token_len = scope.allocate(NativeHelper.C_LONG);
            token_len.set(NativeHelper.C_LONG, 0L, token.byteSize());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting header info (fromPacket)...");
            }
            if (packet.isDirect()) {
                packetReadSegment = MemorySegment.ofBuffer(packet);
                rc = quiche_h.quiche_header_info(packetReadSegment, packet.remaining(), 20L, version, type, scid, scid_len, dcid, dcid_len, token, token_len);
            } else {
                packetReadSegment = scope.allocate(packet.remaining());
                int prevPosition = packet.position();
                packetReadSegment.asByteBuffer().put(packet);
                packet.position(prevPosition);
                rc = quiche_h.quiche_header_info(packetReadSegment, packet.remaining(), 20L, version, type, scid, scid_len, dcid, dcid_len, token, token_len);
            }
            if (rc < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("quiche cannot read header info from packet {}", (Object)BufferUtil.toDetailString((ByteBuffer)packet));
                }
                packetReadSegment = null;
                return packetReadSegment;
            }
            byte[] bytes = new byte[(int)dcid_len.get(NativeHelper.C_LONG, 0L)];
            dcid.asByteBuffer().get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static ForeignQuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer) throws IOException {
        return ForeignQuicheConnection.connect(quicheConfig, local, peer, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForeignQuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        if (connectionIdLength > 20) {
            throw new IOException("Connection ID length is too large: " + connectionIdLength + " > 20");
        }
        Arena arena = Arena.ofShared();
        boolean keepScope = false;
        try {
            byte[] scidBytes = new byte[connectionIdLength];
            SECURE_RANDOM.nextBytes(scidBytes);
            MemorySegment scid = arena.allocate(scidBytes.length);
            scid.asByteBuffer().put(scidBytes);
            MemorySegment libQuicheConfig = ForeignQuicheConnection.buildConfig(quicheConfig, arena);
            MemorySegment localSockaddr = sockaddr.convert(local, arena);
            MemorySegment peerSockaddr = sockaddr.convert(peer, arena);
            MemorySegment quicheConn = quiche_h.quiche_connect(arena.allocateFrom(peer.getHostString()), scid, scid.byteSize(), localSockaddr, (int)localSockaddr.byteSize(), peerSockaddr, (int)peerSockaddr.byteSize(), libQuicheConfig);
            ForeignQuicheConnection connection = new ForeignQuicheConnection(quicheConn, libQuicheConfig, arena);
            keepScope = true;
            ForeignQuicheConnection foreignQuicheConnection = connection;
            return foreignQuicheConnection;
        }
        finally {
            if (!keepScope) {
                arena.close();
            }
        }
    }

    private static MemorySegment buildConfig(QuicheConfig config, SegmentAllocator allocator) throws IOException {
        Long activeConnectionIdLimit;
        Long maxStreamWindow;
        Long maxConnectionWindow;
        Boolean disableActiveMigration;
        Long initialMaxStreamsUni;
        Long initialMaxStreamsBidi;
        Long initialMaxStreamDataUni;
        Long initialMaxStreamDataBidiRemote;
        Long initialMaxStreamDataBidiLocal;
        Long initialMaxData;
        Long maxIdleTimeout;
        QuicheConfig.CongestionControl cc;
        int rc;
        int rc2;
        int rc3;
        String trustedCertsPemPath;
        MemorySegment quicheConfig = quiche_h.quiche_config_new(config.getVersion());
        if (quicheConfig == null) {
            throw new IOException("Failed to create quiche config");
        }
        Boolean verifyPeer = config.getVerifyPeer();
        if (verifyPeer != null) {
            quiche_h.quiche_config_verify_peer(quicheConfig, verifyPeer);
        }
        if ((trustedCertsPemPath = config.getTrustedCertsPemPath()) != null && (rc3 = quiche_h.quiche_config_load_verify_locations_from_file(quicheConfig, allocator.allocateFrom(trustedCertsPemPath))) < 0) {
            throw new IOException("Error loading trusted certificates file " + trustedCertsPemPath + " : " + Quiche.quiche_error.errToString((long)rc3));
        }
        String certChainPemPath = config.getCertChainPemPath();
        if (certChainPemPath != null && (rc2 = quiche_h.quiche_config_load_cert_chain_from_pem_file(quicheConfig, allocator.allocateFrom(certChainPemPath))) < 0) {
            throw new IOException("Error loading certificate chain file " + certChainPemPath + " : " + Quiche.quiche_error.errToString((long)rc2));
        }
        String privKeyPemPath = config.getPrivKeyPemPath();
        if (privKeyPemPath != null && (rc = quiche_h.quiche_config_load_priv_key_from_pem_file(quicheConfig, allocator.allocateFrom(privKeyPemPath))) < 0) {
            throw new IOException("Error loading private key file " + privKeyPemPath + " : " + Quiche.quiche_error.errToString((long)rc));
        }
        String[] applicationProtos = config.getApplicationProtos();
        if (applicationProtos != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String proto : applicationProtos) {
                byte[] bytes = proto.getBytes(StandardCharsets.UTF_8);
                baos.write(bytes.length);
                baos.write(bytes);
            }
            byte[] bytes = baos.toByteArray();
            MemorySegment segment = allocator.allocate(bytes.length);
            segment.asByteBuffer().put(bytes);
            quiche_h.quiche_config_set_application_protos(quicheConfig, segment, segment.byteSize());
        }
        if ((cc = config.getCongestionControl()) != null) {
            quiche_h.quiche_config_set_cc_algorithm(quicheConfig, cc.getValue());
        }
        if ((maxIdleTimeout = config.getMaxIdleTimeout()) != null) {
            quiche_h.quiche_config_set_max_idle_timeout(quicheConfig, maxIdleTimeout);
        }
        if ((initialMaxData = config.getInitialMaxData()) != null) {
            quiche_h.quiche_config_set_initial_max_data(quicheConfig, initialMaxData);
        }
        if ((initialMaxStreamDataBidiLocal = config.getInitialMaxStreamDataBidiLocal()) != null) {
            quiche_h.quiche_config_set_initial_max_stream_data_bidi_local(quicheConfig, initialMaxStreamDataBidiLocal);
        }
        if ((initialMaxStreamDataBidiRemote = config.getInitialMaxStreamDataBidiRemote()) != null) {
            quiche_h.quiche_config_set_initial_max_stream_data_bidi_remote(quicheConfig, initialMaxStreamDataBidiRemote);
        }
        if ((initialMaxStreamDataUni = config.getInitialMaxStreamDataUni()) != null) {
            quiche_h.quiche_config_set_initial_max_stream_data_uni(quicheConfig, initialMaxStreamDataUni);
        }
        if ((initialMaxStreamsBidi = config.getInitialMaxStreamsBidi()) != null) {
            quiche_h.quiche_config_set_initial_max_streams_bidi(quicheConfig, initialMaxStreamsBidi);
        }
        if ((initialMaxStreamsUni = config.getInitialMaxStreamsUni()) != null) {
            quiche_h.quiche_config_set_initial_max_streams_uni(quicheConfig, initialMaxStreamsUni);
        }
        if ((disableActiveMigration = config.getDisableActiveMigration()) != null) {
            quiche_h.quiche_config_set_disable_active_migration(quicheConfig, disableActiveMigration);
        }
        if ((maxConnectionWindow = config.getMaxConnectionWindow()) != null) {
            quiche_h.quiche_config_set_max_connection_window(quicheConfig, maxConnectionWindow);
        }
        if ((maxStreamWindow = config.getMaxStreamWindow()) != null) {
            quiche_h.quiche_config_set_max_stream_window(quicheConfig, maxStreamWindow);
        }
        if ((activeConnectionIdLimit = config.getActiveConnectionIdLimit()) != null) {
            quiche_h.quiche_config_set_active_connection_id_limit(quicheConfig, activeConnectionIdLimit);
        }
        return quicheConfig;
    }

    public static boolean negotiate(QuicheConnection.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        try (Arena scope = Arena.ofConfined();){
            int rc;
            MemorySegment packetReadSegment;
            if (packetRead.isDirect()) {
                packetReadSegment = MemorySegment.ofBuffer(packetRead);
            } else {
                packetReadSegment = scope.allocate(packetRead.remaining());
                int prevPosition = packetRead.position();
                packetReadSegment.asByteBuffer().put(packetRead);
                packetRead.position(prevPosition);
            }
            MemorySegment type = scope.allocate(NativeHelper.C_CHAR);
            MemorySegment version = scope.allocate(NativeHelper.C_INT);
            MemorySegment scid = scope.allocate(20L);
            MemorySegment scid_len = scope.allocate(NativeHelper.C_LONG);
            scid_len.set(NativeHelper.C_LONG, 0L, scid.byteSize());
            MemorySegment dcid = scope.allocate(20L);
            MemorySegment dcid_len = scope.allocate(NativeHelper.C_LONG);
            dcid_len.set(NativeHelper.C_LONG, 0L, dcid.byteSize());
            MemorySegment token = scope.allocate(48L);
            MemorySegment token_len = scope.allocate(NativeHelper.C_LONG);
            token_len.set(NativeHelper.C_LONG, 0L, token.byteSize());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting header info (negotiate)...");
            }
            if ((rc = quiche_h.quiche_header_info(packetReadSegment, packetRead.remaining(), 20L, version, type, scid, scid_len, dcid, dcid_len, token, token_len)) < 0) {
                throw new IOException("failed to parse header: " + Quiche.quiche_error.errToString((long)rc));
            }
            packetRead.position(packetRead.limit());
            if (LOG.isDebugEnabled()) {
                LOG.debug("version: {}", (Object)version.get(NativeHelper.C_INT, 0L));
                LOG.debug("type: {}", (Object)type.get(NativeHelper.C_CHAR, 0L));
                LOG.debug("scid len: {}", (Object)scid_len.get(NativeHelper.C_LONG, 0L));
                LOG.debug("dcid len: {}", (Object)dcid_len.get(NativeHelper.C_LONG, 0L));
                LOG.debug("token len: {}", (Object)token_len.get(NativeHelper.C_LONG, 0L));
            }
            if (!quiche_h.quiche_version_is_supported(version.get(NativeHelper.C_INT, 0L))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("version negotiation");
                }
                MemorySegment packetToSendSegment = packetToSend.isDirect() ? MemorySegment.ofBuffer(packetToSend) : scope.allocate(packetToSend.remaining());
                long generated = quiche_h.quiche_negotiate_version(scid, scid_len.get(NativeHelper.C_LONG, 0L), dcid, dcid_len.get(NativeHelper.C_LONG, 0L), packetToSendSegment, packetToSend.remaining());
                if (generated < 0L) {
                    throw new IOException("failed to create vneg packet : " + Quiche.quiche_error.errToString((long)generated));
                }
                if (!packetToSend.isDirect()) {
                    packetToSend.put(packetToSendSegment.asByteBuffer().limit((int)generated));
                } else {
                    packetToSend.position((int)((long)packetToSend.position() + generated));
                }
                boolean bl = true;
                return bl;
            }
            if (token_len.get(NativeHelper.C_LONG, 0L) == 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("stateless retry");
                }
                byte[] dcidBytes = new byte[(int)dcid_len.get(NativeHelper.C_LONG, 0L)];
                dcid.asByteBuffer().get(dcidBytes);
                byte[] tokenBytes = tokenMinter.mint(dcidBytes, dcidBytes.length);
                token.asByteBuffer().put(tokenBytes);
                byte[] newCid = new byte[20];
                SECURE_RANDOM.nextBytes(newCid);
                MemorySegment newCidSegment = scope.allocate(newCid.length);
                newCidSegment.asByteBuffer().put(newCid);
                MemorySegment packetToSendSegment = packetToSend.isDirect() ? MemorySegment.ofBuffer(packetToSend) : scope.allocate(packetToSend.remaining());
                long generated = quiche_h.quiche_retry(scid, scid_len.get(NativeHelper.C_LONG, 0L), dcid, dcid_len.get(NativeHelper.C_LONG, 0L), newCidSegment, newCid.length, token, tokenBytes.length, version.get(NativeHelper.C_INT, 0L), packetToSendSegment, packetToSendSegment.byteSize());
                if (generated < 0L) {
                    throw new IOException("failed to create retry packet: " + Quiche.quiche_error.errToString((long)generated));
                }
                if (!packetToSend.isDirect()) {
                    packetToSend.put(packetToSendSegment.asByteBuffer().limit((int)generated));
                } else {
                    packetToSend.position((int)((long)packetToSend.position() + generated));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForeignQuicheConnection tryAccept(QuicheConfig quicheConfig, QuicheConnection.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        boolean keepScope = false;
        Arena scope = Arena.ofShared();
        try {
            MemorySegment packetReadSegment;
            Arena segmentScope;
            int rc;
            MemorySegment type = scope.allocate(NativeHelper.C_CHAR);
            MemorySegment version = scope.allocate(NativeHelper.C_INT);
            MemorySegment scid = scope.allocate(20L);
            MemorySegment scid_len = scope.allocate(NativeHelper.C_LONG);
            scid_len.set(NativeHelper.C_LONG, 0L, scid.byteSize());
            MemorySegment dcid = scope.allocate(20L);
            MemorySegment dcid_len = scope.allocate(NativeHelper.C_LONG);
            dcid_len.set(NativeHelper.C_LONG, 0L, dcid.byteSize());
            MemorySegment token = scope.allocate(48L);
            MemorySegment token_len = scope.allocate(NativeHelper.C_LONG);
            token_len.set(NativeHelper.C_LONG, 0L, token.byteSize());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting header info (tryAccept)...");
            }
            if (packetRead.isDirect()) {
                MemorySegment packetReadSegment2 = MemorySegment.ofBuffer(packetRead);
                rc = quiche_h.quiche_header_info(packetReadSegment2, packetRead.remaining(), 20L, version, type, scid, scid_len, dcid, dcid_len, token, token_len);
            } else {
                segmentScope = Arena.ofConfined();
                try {
                    packetReadSegment = segmentScope.allocate(packetRead.remaining());
                    int prevPosition = packetRead.position();
                    packetReadSegment.asByteBuffer().put(packetRead);
                    packetRead.position(prevPosition);
                    rc = quiche_h.quiche_header_info(packetReadSegment, packetRead.remaining(), 20L, version, type, scid, scid_len, dcid, dcid_len, token, token_len);
                }
                finally {
                    if (segmentScope != null) {
                        segmentScope.close();
                    }
                }
            }
            if (rc < 0) {
                throw new IOException("failed to parse header: " + Quiche.quiche_error.errToString((long)rc));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("version: {}", (Object)version.get(NativeHelper.C_INT, 0L));
                LOG.debug("type: {}", (Object)type.get(NativeHelper.C_CHAR, 0L));
                LOG.debug("scid len: {}", (Object)scid_len.get(NativeHelper.C_LONG, 0L));
                LOG.debug("dcid len: {}", (Object)dcid_len.get(NativeHelper.C_LONG, 0L));
                LOG.debug("token len: {}", (Object)token_len.get(NativeHelper.C_LONG, 0L));
            }
            if (!quiche_h.quiche_version_is_supported(version.get(NativeHelper.C_INT, 0L))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("need version negotiation");
                }
                segmentScope = null;
                return segmentScope;
            }
            int tokenLen = (int)token_len.get(NativeHelper.C_LONG, 0L);
            if (tokenLen == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("need stateless retry");
                }
                packetReadSegment = null;
                return packetReadSegment;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("token validation...");
            }
            byte[] tokenBytes = new byte[(int)token.byteSize()];
            token.asByteBuffer().get(tokenBytes, 0, tokenLen);
            byte[] odcidBytes = tokenValidator.validate(tokenBytes, tokenLen);
            if (odcidBytes == null) {
                throw new QuicheConnection.TokenValidationException("invalid address validation token");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("validated token");
            }
            MemorySegment odcid = scope.allocate(odcidBytes.length);
            odcid.asByteBuffer().put(odcidBytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug("connection creation...");
            }
            MemorySegment libQuicheConfig = ForeignQuicheConnection.buildConfig(quicheConfig, scope);
            MemorySegment localSockaddr = sockaddr.convert(local, scope);
            MemorySegment peerSockaddr = sockaddr.convert(peer, scope);
            MemorySegment quicheConn = quiche_h.quiche_accept(dcid, dcid_len.get(NativeHelper.C_LONG, 0L), odcid, odcid.byteSize(), localSockaddr, (int)localSockaddr.byteSize(), peerSockaddr, (int)peerSockaddr.byteSize(), libQuicheConfig);
            if (quicheConn == null) {
                quiche_h.quiche_config_free(libQuicheConfig);
                throw new IOException("failed to create connection");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("connection created");
            }
            ForeignQuicheConnection quicheConnection = new ForeignQuicheConnection(quicheConn, libQuicheConfig, scope);
            if (LOG.isDebugEnabled()) {
                LOG.debug("accepted, immediately receiving the same packet - remaining in buffer: {}", (Object)packetRead.remaining());
            }
            while (packetRead.hasRemaining()) {
                quicheConnection.feedCipherBytes(packetRead, local, peer);
            }
            keepScope = true;
            ForeignQuicheConnection foreignQuicheConnection = quicheConnection;
            return foreignQuicheConnection;
        }
        finally {
            if (!keepScope) {
                scope.close();
            }
        }
    }

    public byte[] getPeerCertificate() {
        try (AutoLock ignore = this.lock.lock();){
            long outLen;
            MemorySegment outSegment;
            Arena scope;
            block17: {
                if (this.quicheConn == null) {
                    throw new IllegalStateException("connection was released");
                }
                scope = Arena.ofConfined();
                try {
                    outSegment = scope.allocate(NativeHelper.C_POINTER);
                    MemorySegment outLenSegment = scope.allocate(NativeHelper.C_LONG);
                    quiche_h.quiche_conn_peer_cert(this.quicheConn, outSegment, outLenSegment);
                    outLen = outLenSegment.get(NativeHelper.C_LONG, 0L);
                    if (outLen > 0L) break block17;
                    byte[] byArray = null;
                    if (scope != null) {
                        scope.close();
                    }
                    return byArray;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            byte[] out = new byte[(int)outLen];
            outSegment.get(NativeHelper.C_POINTER, 0L).reinterpret(outLen).asByteBuffer().get(out);
            byte[] byArray = out;
            if (scope != null) {
                scope.close();
            }
            return byArray;
        }
    }

    protected List<Long> iterableStreamIds(boolean write) {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            MemorySegment quiche_stream_iter = write ? quiche_h.quiche_conn_writable(this.quicheConn) : quiche_h.quiche_conn_readable(this.quicheConn);
            ArrayList<Long> result = new ArrayList<Long>();
            try (Arena scope = Arena.ofConfined();){
                MemorySegment streamIdSegment = scope.allocate(NativeHelper.C_LONG);
                while (quiche_h.quiche_stream_iter_next(quiche_stream_iter, streamIdSegment)) {
                    long streamId = streamIdSegment.get(NativeHelper.C_LONG, 0L);
                    result.add(streamId);
                }
            }
            quiche_h.quiche_stream_iter_free(quiche_stream_iter);
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
    }

    public int feedCipherBytes(ByteBuffer buffer, SocketAddress local, SocketAddress peer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long received;
            if (this.quicheConn == null) {
                throw new IOException("Cannot receive when not connected");
            }
            try (Arena scope = Arena.ofConfined();){
                quiche_recv_info.setSocketAddress(this.recvInfo, local, peer, scope);
                if (buffer.isDirect()) {
                    MemorySegment bufferSegment = MemorySegment.ofBuffer(buffer);
                    received = quiche_h.quiche_conn_recv(this.quicheConn, bufferSegment, buffer.remaining(), this.recvInfo);
                } else {
                    MemorySegment bufferSegment = scope.allocate(buffer.remaining());
                    int prevPosition = buffer.position();
                    bufferSegment.asByteBuffer().put(buffer);
                    buffer.position(prevPosition);
                    received = quiche_h.quiche_conn_recv(this.quicheConn, bufferSegment, buffer.remaining(), this.recvInfo);
                }
            }
            if (received < 0L) {
                throw new IOException("failed to receive packet; quiche_err=" + Quiche.quiche_error.errToString((long)received) + " quic_err=" + Quiche.quic_error.errToString((long)this.getLocalCloseInfo().error()));
            }
            buffer.position((int)((long)buffer.position() + received));
            int n = (int)received;
            return n;
        }
    }

    public int drainCipherBytes(ByteBuffer buffer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long written;
            if (this.quicheConn == null) {
                throw new IOException("Cannot send when not connected");
            }
            int prevPosition = buffer.position();
            if (buffer.isDirect()) {
                MemorySegment bufferSegment = MemorySegment.ofBuffer(buffer);
                written = quiche_h.quiche_conn_send(this.quicheConn, bufferSegment, buffer.remaining(), this.sendInfo);
            } else {
                try (Arena scope = Arena.ofConfined();){
                    MemorySegment bufferSegment = scope.allocate(buffer.remaining());
                    written = quiche_h.quiche_conn_send(this.quicheConn, bufferSegment, buffer.remaining(), this.sendInfo);
                    buffer.put(bufferSegment.asByteBuffer().slice().limit((int)written));
                    buffer.position(prevPosition);
                }
            }
            if (written == -1L) {
                int n = 0;
                return n;
            }
            if (written < 0L) {
                throw new IOException("failed to send packet; quiche_err=" + Quiche.quiche_error.errToString((long)written));
            }
            buffer.position((int)((long)prevPosition + written));
            int n = (int)written;
            return n;
        }
    }

    public boolean isConnectionClosed() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_is_closed(this.quicheConn);
            return bl;
        }
    }

    public boolean isConnectionEstablished() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_is_established(this.quicheConn);
            return bl;
        }
    }

    public long nextTimeout() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            long l = quiche_h.quiche_conn_timeout_as_millis(this.quicheConn);
            return l;
        }
    }

    public void onTimeout() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            quiche_h.quiche_conn_on_timeout(this.quicheConn);
        }
    }

    public String getNegotiatedProtocol() {
        try (AutoLock ignore = this.lock.lock();){
            long outLen;
            MemorySegment outSegment;
            Arena scope;
            block17: {
                scope = Arena.ofConfined();
                try {
                    if (this.quicheConn == null) {
                        throw new IllegalStateException("connection was released");
                    }
                    outSegment = scope.allocate(NativeHelper.C_POINTER);
                    MemorySegment outLenSegment = scope.allocate(NativeHelper.C_LONG);
                    quiche_h.quiche_conn_application_proto(this.quicheConn, outSegment, outLenSegment);
                    outLen = outLenSegment.get(NativeHelper.C_LONG, 0L);
                    if (outLen != 0L) break block17;
                    String string = null;
                    if (scope != null) {
                        scope.close();
                    }
                    return string;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            byte[] out = new byte[(int)outLen];
            outSegment.get(NativeHelper.C_POINTER, 0L).reinterpret(outLen).asByteBuffer().get(out);
            String string = new String(out, StandardCharsets.UTF_8);
            if (scope != null) {
                scope.close();
            }
            return string;
        }
    }

    public boolean close(long error, String reason) {
        try (AutoLock ignore = this.lock.lock();){
            int rc;
            if (this.quicheConn == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connection was released");
                }
                boolean bl = false;
                return bl;
            }
            if (reason == null) {
                rc = quiche_h.quiche_conn_close(this.quicheConn, true, error, MemorySegment.NULL, 0L);
            } else {
                try (Arena scope = Arena.ofConfined();){
                    byte[] reasonBytes = reason.getBytes(StandardCharsets.UTF_8);
                    MemorySegment reasonSegment = scope.allocate(reasonBytes.length);
                    reasonSegment.asByteBuffer().put(reasonBytes);
                    int length = reasonBytes.length;
                    rc = quiche_h.quiche_conn_close(this.quicheConn, true, error, reasonSegment, length);
                }
            }
            if (rc == 0) {
                boolean bl = true;
                return bl;
            }
            if ((long)rc == -1L) {
                boolean bl = false;
                return bl;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not close connection: {}", (Object)Quiche.quiche_error.errToString((long)rc));
            }
            boolean bl = false;
            return bl;
        }
    }

    public void dispose() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn != null) {
                quiche_h.quiche_conn_free(this.quicheConn);
            }
            this.quicheConn = null;
            if (this.quicheConfig != null) {
                quiche_h.quiche_config_free(this.quicheConfig);
            }
            this.quicheConfig = null;
            if (this.scope != null) {
                this.scope.close();
            }
            this.scope = null;
            this.sendInfo = null;
            this.recvInfo = null;
            this.transportParams = null;
            this.pathStats = null;
        }
    }

    public boolean isDraining() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_is_draining(this.quicheConn);
            return bl;
        }
    }

    public int maxLocalStreams() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            quiche_h.quiche_conn_peer_transport_params(this.quicheConn, this.transportParams);
            int n = (int)quiche_transport_params.get_peer_initial_max_streams_bidi(this.transportParams);
            return n;
        }
    }

    public long windowCapacity() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            quiche_h.quiche_conn_path_stats(this.quicheConn, 0L, this.pathStats);
            long l = quiche_path_stats.get_cwnd(this.pathStats);
            return l;
        }
    }

    public long windowCapacity(long streamId) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            long value = quiche_h.quiche_conn_stream_capacity(this.quicheConn, streamId);
            if (value < 0L && LOG.isDebugEnabled()) {
                LOG.debug("could not read window capacity for stream {} quiche_err={}", (Object)streamId, (Object)Quiche.quiche_error.errToString((long)value));
            }
            long l = value;
            return l;
        }
    }

    public void shutdownStream(long streamId, boolean writeSide, long error) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            int direction = writeSide ? 1 : 0;
            int rc = quiche_h.quiche_conn_stream_shutdown(this.quicheConn, streamId, direction, error);
            if (rc == 0 || (long)rc == -1L) {
                return;
            }
            throw new IOException("failed to shutdown stream " + streamId + ": " + Quiche.quiche_error.errToString((long)rc));
        }
    }

    public int feedClearBytesForStream(long streamId, ByteBuffer buffer, boolean last) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long written;
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            try (Arena scope = Arena.ofConfined();){
                MemorySegment outErrorCode = scope.allocate(NativeHelper.C_LONG);
                if (buffer.isDirect()) {
                    MemorySegment bufferSegment = MemorySegment.ofBuffer(buffer);
                    written = quiche_h.quiche_conn_stream_send(this.quicheConn, streamId, bufferSegment, buffer.remaining(), last, outErrorCode);
                } else if (buffer.remaining() == 0) {
                    written = quiche_h.quiche_conn_stream_send(this.quicheConn, streamId, MemorySegment.NULL, 0L, last, outErrorCode);
                } else {
                    MemorySegment bufferSegment = scope.allocate(buffer.remaining());
                    int prevPosition = buffer.position();
                    bufferSegment.asByteBuffer().put(buffer);
                    buffer.position(prevPosition);
                    written = quiche_h.quiche_conn_stream_send(this.quicheConn, streamId, bufferSegment, buffer.remaining(), last, outErrorCode);
                }
            }
            if (written == -1L) {
                int rc = quiche_h.quiche_conn_stream_writable(this.quicheConn, streamId, buffer.remaining());
                if (rc < 0) {
                    throw new IOException("failed to write to stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)rc));
                }
                int n = 0;
                return n;
            }
            if (written < 0L) {
                throw new IOException("failed to write to stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)written));
            }
            buffer.position((int)((long)buffer.position() + written));
            int n = (int)written;
            return n;
        }
    }

    public int drainClearBytesForStream(long streamId, ByteBuffer buffer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            long read;
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            try (Arena scope = Arena.ofConfined();){
                MemorySegment fin = scope.allocate(NativeHelper.C_CHAR);
                MemorySegment outErrorCode = scope.allocate(NativeHelper.C_LONG);
                if (buffer.isDirect()) {
                    MemorySegment bufferSegment = MemorySegment.ofBuffer(buffer);
                    read = quiche_h.quiche_conn_stream_recv(this.quicheConn, streamId, bufferSegment, buffer.remaining(), fin, outErrorCode);
                } else {
                    MemorySegment bufferSegment = scope.allocate(buffer.remaining());
                    read = quiche_h.quiche_conn_stream_recv(this.quicheConn, streamId, bufferSegment, buffer.remaining(), fin, outErrorCode);
                    if (read > 0L) {
                        int prevPosition = buffer.position();
                        buffer.put(bufferSegment.asByteBuffer().limit((int)read));
                        buffer.position(prevPosition);
                    }
                }
            }
            if (read == -1L) {
                int n = this.isStreamFinished(streamId) ? -1 : 0;
                return n;
            }
            if (read == -16L) {
                throw new EOFException("failed to read from stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)read));
            }
            if (read < 0L) {
                throw new IOException("failed to read from stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)read));
            }
            buffer.position((int)((long)buffer.position() + read));
            int n = (int)read;
            return n;
        }
    }

    public boolean isStreamFinished(long streamId) {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = quiche_h.quiche_conn_stream_finished(this.quicheConn, streamId);
            return bl;
        }
    }

    public QuicheConnection.CloseInfo getRemoteCloseInfo() {
        try (AutoLock ignore = this.lock.lock();){
            Arena scope;
            block19: {
                if (this.quicheConn == null) {
                    throw new IllegalStateException("connection was released");
                }
                scope = Arena.ofConfined();
                try {
                    String reasonValue;
                    MemorySegment app = scope.allocate(NativeHelper.C_CHAR);
                    MemorySegment error = scope.allocate(NativeHelper.C_LONG);
                    MemorySegment reason = scope.allocate(NativeHelper.C_POINTER);
                    MemorySegment reasonLength = scope.allocate(NativeHelper.C_LONG);
                    if (!quiche_h.quiche_conn_peer_error(this.quicheConn, app, error, reason, reasonLength)) break block19;
                    long errorValue = error.get(NativeHelper.C_LONG, 0L);
                    long reasonLengthValue = reasonLength.get(NativeHelper.C_LONG, 0L);
                    if (reasonLengthValue == 0L) {
                        reasonValue = null;
                    } else {
                        byte[] reasonBytes = new byte[(int)reasonLengthValue];
                        reason.get(NativeHelper.C_POINTER, 0L).reinterpret(reasonLengthValue).asByteBuffer().get(reasonBytes);
                        reasonValue = new String(reasonBytes, StandardCharsets.UTF_8);
                    }
                    QuicheConnection.CloseInfo closeInfo = new QuicheConnection.CloseInfo(errorValue, reasonValue);
                    if (scope != null) {
                        scope.close();
                    }
                    return closeInfo;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            QuicheConnection.CloseInfo closeInfo = null;
            if (scope != null) {
                scope.close();
            }
            return closeInfo;
        }
    }

    public QuicheConnection.CloseInfo getLocalCloseInfo() {
        try (AutoLock ignore = this.lock.lock();){
            Arena scope;
            block19: {
                if (this.quicheConn == null) {
                    throw new IllegalStateException("connection was released");
                }
                scope = Arena.ofConfined();
                try {
                    String reasonValue;
                    MemorySegment app = scope.allocate(NativeHelper.C_CHAR);
                    MemorySegment error = scope.allocate(NativeHelper.C_LONG);
                    MemorySegment reason = scope.allocate(NativeHelper.C_POINTER);
                    MemorySegment reasonLength = scope.allocate(NativeHelper.C_LONG);
                    if (!quiche_h.quiche_conn_local_error(this.quicheConn, app, error, reason, reasonLength)) break block19;
                    long errorValue = error.get(NativeHelper.C_LONG, 0L);
                    long reasonLengthValue = reasonLength.get(NativeHelper.C_LONG, 0L);
                    if (reasonLengthValue == 0L) {
                        reasonValue = null;
                    } else {
                        byte[] reasonBytes = new byte[(int)reasonLengthValue];
                        reason.get(NativeHelper.C_POINTER, 0L).reinterpret(reasonLengthValue).asByteBuffer().get(reasonBytes);
                        reasonValue = new String(reasonBytes, StandardCharsets.UTF_8);
                    }
                    QuicheConnection.CloseInfo closeInfo = new QuicheConnection.CloseInfo(errorValue, reasonValue);
                    if (scope != null) {
                        scope.close();
                    }
                    return closeInfo;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            QuicheConnection.CloseInfo closeInfo = null;
            if (scope != null) {
                scope.close();
            }
            return closeInfo;
        }
    }
}

