/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EventListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.DatagramChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.quic.common.QuicSessionContainer;
import org.eclipse.jetty.quic.server.QuicServerConnectionFactory;
import org.eclipse.jetty.quic.server.ServerQuicConfiguration;
import org.eclipse.jetty.quic.server.ServerQuicConnection;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class QuicServerConnector
extends AbstractNetworkConnector {
    private final QuicSessionContainer container = new QuicSessionContainer();
    private final ServerDatagramSelectorManager selectorManager = new ServerDatagramSelectorManager(this.getExecutor(), this.getScheduler(), 1);
    private final QuicServerConnectionFactory connectionFactory;
    private volatile DatagramChannel datagramChannel;
    private volatile int localPort = -1;

    @Deprecated(since="12.0.7", forRemoval=true)
    public QuicServerConnector(Server server, SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        this(server, new ServerQuicConfiguration(sslContextFactory, null), factories);
    }

    public QuicServerConnector(Server server, ServerQuicConfiguration quicConfiguration, ConnectionFactory ... factories) {
        this(server, null, null, null, quicConfiguration, factories);
    }

    @Deprecated(since="12.0.7", forRemoval=true)
    public QuicServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        this(server, executor, scheduler, bufferPool, new ServerQuicConfiguration(sslContextFactory, null), factories);
    }

    public QuicServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, ServerQuicConfiguration quicConfiguration, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, 0, factories);
        this.connectionFactory = new QuicServerConnectionFactory(quicConfiguration);
    }

    public ServerQuicConfiguration getQuicConfiguration() {
        return this.connectionFactory.getQuicConfiguration();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getInputBufferSize() {
        return this.getQuicConfiguration().getInputBufferSize();
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.getQuicConfiguration().setInputBufferSize(inputBufferSize);
    }

    public int getOutputBufferSize() {
        return this.getQuicConfiguration().getOutputBufferSize();
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.getQuicConfiguration().setOutputBufferSize(outputBufferSize);
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.getQuicConfiguration().isUseInputDirectByteBuffers();
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.getQuicConfiguration().setUseInputDirectByteBuffers(useInputDirectByteBuffers);
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.getQuicConfiguration().isUseOutputDirectByteBuffers();
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.getQuicConfiguration().setUseOutputDirectByteBuffers(useOutputDirectByteBuffers);
    }

    public boolean isOpen() {
        DatagramChannel channel = this.datagramChannel;
        return channel != null && channel.isOpen();
    }

    protected void doStart() throws Exception {
        this.addBean(this.container);
        this.addBean((Object)this.selectorManager);
        this.addBean((Object)this.connectionFactory);
        for (EventListener l : this.getBeans(SelectorManager.SelectorManagerListener.class)) {
            this.selectorManager.addEventListener(l);
        }
        this.connectionFactory.getQuicConfiguration().setPemWorkDirectory(this.findPemWorkDirectory());
        super.doStart();
        this.selectorManager.accept(this.datagramChannel);
    }

    private Path findPemWorkDirectory() {
        Path pemWorkDirectory = this.getQuicConfiguration().getPemWorkDirectory();
        if (pemWorkDirectory != null) {
            return pemWorkDirectory;
        }
        String jettyBase = System.getProperty("jetty.base");
        if (jettyBase != null && Files.exists(pemWorkDirectory = Path.of(jettyBase, new String[0]).resolve("work"), new LinkOption[0])) {
            return pemWorkDirectory;
        }
        throw new IllegalStateException("No PEM work directory configured");
    }

    public void open() throws IOException {
        if (this.datagramChannel == null) {
            this.datagramChannel = this.openDatagramChannel();
            this.datagramChannel.configureBlocking(false);
            this.localPort = this.datagramChannel.socket().getLocalPort();
            if (this.localPort <= 0) {
                throw new IOException("DatagramChannel not bound");
            }
            this.addBean(this.datagramChannel);
        }
    }

    protected DatagramChannel openDatagramChannel() throws IOException {
        InetSocketAddress bindAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        DatagramChannel datagramChannel = DatagramChannel.open();
        try {
            datagramChannel.bind(bindAddress);
            return datagramChannel;
        }
        catch (Throwable e) {
            IO.close((Closeable)datagramChannel);
            throw new IOException("Failed to bind to " + String.valueOf(bindAddress), e);
        }
    }

    public void setIdleTimeout(long idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        this.selectorManager.setIdleTimeout(idleTimeout);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.datagramChannel);
        this.datagramChannel = null;
        this.localPort = -2;
        this.removeBean((Object)this.connectionFactory);
        for (EventListener l : this.getBeans(EventListener.class)) {
            this.selectorManager.removeEventListener(l);
        }
    }

    public CompletableFuture<Void> shutdown() {
        return this.container.shutdown();
    }

    public Object getTransport() {
        return this.datagramChannel;
    }

    protected void accept(int acceptorID) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + " has no accept mechanism");
    }

    protected EndPoint newEndPoint(DatagramChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
        return new DatagramChannelEndPoint(channel, selector, selectionKey, this.getScheduler());
    }

    protected ServerQuicConnection newConnection(EndPoint endpoint) {
        return this.connectionFactory.newConnection((Connector)this, endpoint);
    }

    private class ServerDatagramSelectorManager
    extends SelectorManager {
        protected ServerDatagramSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            EndPoint endPoint = QuicServerConnector.this.newEndPoint((DatagramChannel)channel, selector, selectionKey);
            endPoint.setIdleTimeout(QuicServerConnector.this.getIdleTimeout());
            return endPoint;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) {
            return QuicServerConnector.this.newConnection(endpoint);
        }

        protected void endPointOpened(EndPoint endpoint) {
            super.endPointOpened(endpoint);
            QuicServerConnector.this.onEndPointOpened(endpoint);
        }

        protected void endPointClosed(EndPoint endpoint) {
            QuicServerConnector.this.onEndPointClosed(endpoint);
            super.endPointClosed(endpoint);
        }

        private void setIdleTimeout(long idleTimeout) {
            QuicServerConnector.this.getConnectedEndPoints().forEach(endPoint -> endPoint.setIdleTimeout(idleTimeout));
        }
    }
}

