/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.http.server.ServletUtils;

public class ClientVersionUtil {
    private static final int[] v1_7_5 = new int[]{1, 7, 5};
    private static final int[] v1_7_8_6 = new int[]{1, 7, 8, 6};
    private static final int[] v1_7_9 = new int[]{1, 7, 9};

    public static int[] invalidVersion() {
        return new int[]{Integer.MAX_VALUE};
    }

    public static int[] parseVersion(String version) {
        if (version != null && version.startsWith("git/")) {
            return ClientVersionUtil.splitVersion(version.substring("git/".length()));
        }
        return ClientVersionUtil.invalidVersion();
    }

    private static int[] splitVersion(String versionString) {
        char[] str = versionString.toCharArray();
        int[] ver = new int[4];
        int end = 0;
        int acc = 0;
        for (int i = 0; i < str.length; ++i) {
            char c = str[i];
            if ('0' <= c && c <= '9') {
                acc *= 10;
                acc += c - 48;
                continue;
            }
            if (c == '.') {
                if (end == ver.length) {
                    ver = ClientVersionUtil.grow(ver);
                }
                ver[end++] = acc;
                acc = 0;
                continue;
            }
            if (c == 'g' && 0 < i && str[i - 1] == '.' && 0 < end) {
                ver[end - 1] = 0;
                acc = 0;
                break;
            }
            if (c != '-' || i + 2 >= str.length || str[i + 1] != 'r' || str[i + 2] != 'c' || acc <= 0) break;
            --acc;
            break;
        }
        if (acc != 0) {
            if (end == ver.length) {
                ver = ClientVersionUtil.grow(ver);
            }
            ver[end++] = acc;
        } else {
            while (0 < end && ver[end - 1] == 0) {
                --end;
            }
        }
        if (end < ver.length) {
            int[] n = new int[end];
            System.arraycopy(ver, 0, n, 0, end);
            ver = n;
        }
        return ver;
    }

    private static int[] grow(int[] tmp) {
        int[] n = new int[tmp.length + 1];
        System.arraycopy(tmp, 0, n, 0, tmp.length);
        return n;
    }

    public static int compare(int[] a, int[] b) {
        for (int i = 0; i < a.length && i < b.length; ++i) {
            int cmp = a[i] - b[i];
            if (cmp == 0) continue;
            return cmp;
        }
        return a.length - b.length;
    }

    public static String toString(int[] ver) {
        StringBuilder b = new StringBuilder();
        for (int v : ver) {
            if (b.length() > 0) {
                b.append('.');
            }
            b.append(v);
        }
        return b.toString();
    }

    public static boolean hasPushStatusBug(int[] version) {
        int cmp = ClientVersionUtil.compare(version, v1_7_8_6);
        if (cmp < 0) {
            return true;
        }
        if (cmp == 0) {
            return false;
        }
        return ClientVersionUtil.compare(version, v1_7_9) <= 0;
    }

    public static boolean hasChunkedEncodingRequestBug(int[] version, HttpServletRequest request) {
        return ClientVersionUtil.compare(version, v1_7_5) == 0 && ServletUtils.isChunked(request);
    }

    private ClientVersionUtil() {
    }
}

