/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.util.log.Logger;

public class RecordingLogger
implements Logger {
    private static List<Warning> warnings = new ArrayList<Warning>();
    private final String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Warning> getWarnings() {
        List<Warning> list = warnings;
        synchronized (list) {
            ArrayList<Warning> copy = new ArrayList<Warning>(warnings);
            return Collections.unmodifiableList(copy);
        }
    }

    public RecordingLogger() {
        this("");
    }

    public RecordingLogger(String name) {
        this.name = name;
    }

    public Logger getLogger(String name) {
        return new RecordingLogger(name);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Object arg0, Object arg1) {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.add(new Warning(MessageFormat.format(msg, arg0, arg1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Throwable th) {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.add(new Warning(msg, th));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg) {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.add(new Warning(msg));
        }
    }

    public void debug(String msg, Object arg0, Object arg1) {
    }

    public void debug(String msg, Throwable th) {
    }

    public void debug(String msg) {
    }

    public void info(String msg, Object arg0, Object arg1) {
    }

    public void info(String msg) {
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void setDebugEnabled(boolean enabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Object ... args) {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.add(new Warning(MessageFormat.format(msg, args)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(Throwable thrown) {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.add(new Warning(thrown));
        }
    }

    public void info(String msg, Object ... args) {
    }

    public void info(Throwable thrown) {
    }

    public void info(String msg, Throwable thrown) {
    }

    public void debug(String msg, Object ... args) {
    }

    public void debug(Throwable thrown) {
    }

    public void ignore(Throwable arg0) {
    }

    public void debug(String msg, long value) {
    }

    public static class Warning
    extends Exception {
        public Warning(String msg) {
            super(msg);
        }

        public Warning(String msg, Throwable cause) {
            super(msg, cause);
        }

        public Warning(Throwable thrown) {
            super(thrown);
        }
    }
}

