/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jgit.junit.http.AccessEvent;
import org.eclipse.jgit.junit.http.HttpTestCase;
import org.eclipse.jgit.junit.http.RecordingLogger;
import org.eclipse.jgit.junit.http.TestRequestLog;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;

public class AppServer {
    public static final String realm = "Secure Area";
    public static final String username = "agitter";
    public static final String password = "letmein";
    private static final String keyPassword = "mykeys";
    private static final String authRole = "can-access";
    private final Server server;
    private final HttpConfiguration config;
    private final ServerConnector connector;
    private final HttpConfiguration secureConfig;
    private final ServerConnector secureConnector;
    private final ContextHandlerCollection contexts;
    private final TestRequestLog log;
    private List<File> filesToDelete = new ArrayList<File>();

    static {
        String prop = "org.eclipse.jetty.util.log.class";
        System.setProperty("org.eclipse.jetty.util.log.class", RecordingLogger.class.getName());
    }

    public AppServer() {
        this(0, -1);
    }

    public AppServer(int port) {
        this(port, -1);
    }

    public AppServer(int port, int sslPort) {
        String hostName;
        String ip;
        this.server = new Server();
        this.config = new HttpConfiguration();
        this.config.setSecureScheme("https");
        this.config.setSecurePort(0);
        this.config.setOutputBufferSize(32768);
        this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(this.config)});
        this.connector.setPort(port);
        try {
            InetAddress me = InetAddress.getByName("localhost");
            ip = me.getHostAddress();
            this.connector.setHost(ip);
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot find localhost", e);
        }
        if (sslPort >= 0) {
            SslContextFactory sslContextFactory = this.createTestSslContextFactory(hostName);
            this.secureConfig = new HttpConfiguration(this.config);
            this.secureConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(this.secureConfig)});
            this.secureConnector.setPort(sslPort);
            this.secureConnector.setHost(ip);
        } else {
            this.secureConfig = null;
            this.secureConnector = null;
        }
        this.contexts = new ContextHandlerCollection();
        this.log = new TestRequestLog();
        this.log.setHandler((Handler)this.contexts);
        if (this.secureConnector == null) {
            this.server.setConnectors(new Connector[]{this.connector});
        } else {
            this.server.setConnectors(new Connector[]{this.connector, this.secureConnector});
        }
        this.server.setHandler((Handler)this.log);
    }

    private SslContextFactory createTestSslContextFactory(String hostName) {
        SslContextFactory factory = new SslContextFactory(true);
        String dName = "CN=,OU=,O=,ST=,L=,C=";
        try {
            File tmpDir = Files.createTempDirectory("jks", new FileAttribute[0]).toFile();
            tmpDir.deleteOnExit();
            this.makePrivate(tmpDir);
            File keyStore = new File(tmpDir, "keystore.jks");
            Runtime.getRuntime().exec(new String[]{"keytool", "-keystore", keyStore.getAbsolutePath(), "-storepass", keyPassword, "-alias", hostName, "-genkeypair", "-keyalg", "RSA", "-keypass", keyPassword, "-dname", dName, "-validity", "2"}).waitFor();
            keyStore.deleteOnExit();
            this.makePrivate(keyStore);
            this.filesToDelete.add(keyStore);
            this.filesToDelete.add(tmpDir);
            factory.setKeyStorePath(keyStore.getAbsolutePath());
            factory.setKeyStorePassword(keyPassword);
            factory.setKeyManagerPassword(keyPassword);
            factory.setTrustStorePath(keyStore.getAbsolutePath());
            factory.setTrustStorePassword(keyPassword);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Cannot create ssl key/certificate", e);
        }
        return factory;
    }

    private void makePrivate(File file) {
        file.setReadable(false);
        file.setWritable(false);
        file.setExecutable(false);
        file.setReadable(true, true);
        file.setWritable(true, true);
        if (file.isDirectory()) {
            file.setExecutable(true, true);
        }
    }

    public ServletContextHandler addContext(String path) {
        this.assertNotYetSetUp();
        if ("".equals(path)) {
            path = "/";
        }
        ServletContextHandler ctx = new ServletContextHandler();
        ctx.setContextPath(path);
        this.contexts.addHandler((Handler)ctx);
        return ctx;
    }

    public ServletContextHandler authBasic(ServletContextHandler ctx, String ... methods) {
        this.assertNotYetSetUp();
        this.auth(ctx, (Authenticator)new BasicAuthenticator(), methods);
        return ctx;
    }

    private ConstraintMapping createConstraintMapping() {
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(new Constraint());
        cm.getConstraint().setAuthenticate(true);
        cm.getConstraint().setDataConstraint(0);
        cm.getConstraint().setRoles(new String[]{authRole});
        cm.setPathSpec("/*");
        return cm;
    }

    private void auth(ServletContextHandler ctx, Authenticator authType, String ... methods) {
        TestMappedLoginService users = new TestMappedLoginService(authRole);
        ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>();
        if (methods == null || methods.length == 0) {
            mappings.add(this.createConstraintMapping());
        } else {
            String[] stringArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                String method = stringArray[n2];
                ConstraintMapping cm = this.createConstraintMapping();
                cm.setMethod(method.toUpperCase(Locale.ROOT));
                mappings.add(cm);
                ++n2;
            }
        }
        ConstraintSecurityHandler sec = new ConstraintSecurityHandler();
        sec.setRealmName(realm);
        sec.setAuthenticator(authType);
        sec.setLoginService((LoginService)users);
        sec.setConstraintMappings(mappings.toArray(new ConstraintMapping[mappings.size()]));
        sec.setHandler((Handler)ctx);
        this.contexts.removeHandler((Handler)ctx);
        this.contexts.addHandler((Handler)sec);
    }

    public void setUp() throws Exception {
        RecordingLogger.clear();
        this.log.clear();
        this.server.start();
        this.config.setSecurePort(this.getSecurePort());
        if (this.secureConfig != null) {
            this.secureConfig.setSecurePort(this.getSecurePort());
        }
    }

    public void tearDown() throws Exception {
        RecordingLogger.clear();
        this.log.clear();
        this.server.stop();
        for (File f : this.filesToDelete) {
            f.delete();
        }
        this.filesToDelete.clear();
    }

    public URI getURI() {
        this.assertAlreadySetUp();
        String host = this.connector.getHost();
        if (host.contains(":") && !host.startsWith("[")) {
            host = "[" + host + "]";
        }
        String uri = "http://" + host + ":" + this.getPort();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected URI error on " + uri, e);
        }
    }

    public int getPort() {
        this.assertAlreadySetUp();
        return this.connector.getLocalPort();
    }

    public int getSecurePort() {
        this.assertAlreadySetUp();
        return this.secureConnector != null ? this.secureConnector.getLocalPort() : -1;
    }

    public List<AccessEvent> getRequests() {
        return new ArrayList<AccessEvent>(this.log.getEvents());
    }

    public List<AccessEvent> getRequests(URIish base, String path) {
        return this.getRequests(HttpTestCase.join(base, path));
    }

    public List<AccessEvent> getRequests(String path) {
        ArrayList<AccessEvent> r = new ArrayList<AccessEvent>();
        for (AccessEvent event : this.log.getEvents()) {
            if (!event.getPath().equals(path)) continue;
            r.add(event);
        }
        return r;
    }

    private void assertNotYetSetUp() {
        Assert.assertFalse((String)"server is not running", (boolean)this.server.isRunning());
    }

    private void assertAlreadySetUp() {
        Assert.assertTrue((String)"server is running", (boolean)this.server.isRunning());
    }

    static class TestMappedLoginService
    extends AbstractLoginService {
        private String role;
        protected final ConcurrentMap<String, AbstractLoginService.UserPrincipal> users = new ConcurrentHashMap<String, AbstractLoginService.UserPrincipal>();

        TestMappedLoginService(String role) {
            this.role = role;
        }

        protected void doStart() throws Exception {
            AbstractLoginService.UserPrincipal p = new AbstractLoginService.UserPrincipal(AppServer.username, (Credential)new Password(AppServer.password));
            this.users.put(AppServer.username, p);
            super.doStart();
        }

        protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
            if (this.users.get(user.getName()) == null) {
                return null;
            }
            return new String[]{this.role};
        }

        protected AbstractLoginService.UserPrincipal loadUserInfo(String user) {
            return (AbstractLoginService.UserPrincipal)this.users.get(user);
        }
    }
}

