/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.junit.JGitTestUtil;
import org.eclipse.jgit.junit.LocalDiskRepositoryTestCase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryTestCase
extends LocalDiskRepositoryTestCase {
    protected FileRepository db;
    protected File trash;
    public static final int MOD_TIME = 1;
    public static final int SMUDGE = 2;
    public static final int LENGTH = 4;
    public static final int CONTENT_ID = 8;
    public static final int CONTENT = 16;
    public static final int ASSUME_UNCHANGED = 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFile(File src, File dst) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        try {
            FileOutputStream fos = new FileOutputStream(dst);
            try {
                int r;
                byte[] buf = new byte[4096];
                while ((r = fis.read(buf)) > 0) {
                    fos.write(buf, 0, r);
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            fis.close();
        }
    }

    protected File writeTrashFile(String name, String data) throws IOException {
        return JGitTestUtil.writeTrashFile((Repository)this.db, name, data);
    }

    protected File writeTrashFile(String subdir, String name, String data) throws IOException {
        return JGitTestUtil.writeTrashFile((Repository)this.db, subdir, name, data);
    }

    protected String read(String name) throws IOException {
        return JGitTestUtil.read((Repository)this.db, name);
    }

    protected void deleteTrashFile(String name) throws IOException {
        JGitTestUtil.deleteTrashFile((Repository)this.db, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkFile(File f, String checkData) throws IOException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), "ISO-8859-1");
        try {
            char[] data = new char[(int)f.length()];
            if (f.length() != (long)r.read(data)) {
                throw new IOException("Internal error reading file data from " + f);
            }
            Assert.assertEquals((Object)checkData, (Object)new String(data));
        }
        finally {
            ((Reader)r).close();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.db = this.createWorkRepository();
        this.trash = this.db.getWorkTree();
    }

    public String indexState(Repository repo, int includedOptions) throws IllegalStateException, IOException {
        int i;
        DirCache dc = repo.readDirCache();
        StringBuilder sb = new StringBuilder();
        TreeSet<Long> timeStamps = null;
        if (0 != (includedOptions & 1)) {
            timeStamps = new TreeSet<Long>();
            for (i = 0; i < dc.getEntryCount(); ++i) {
                timeStamps.add(dc.getEntry(i).getLastModified());
            }
        }
        for (i = 0; i < dc.getEntryCount(); ++i) {
            DirCacheEntry entry = dc.getEntry(i);
            sb.append("[" + entry.getPathString() + ", mode:" + entry.getFileMode());
            int stage = entry.getStage();
            if (stage != 0) {
                sb.append(", stage:" + stage);
            }
            if (0 != (includedOptions & 1)) {
                sb.append(", time:t" + timeStamps.headSet(entry.getLastModified()).size());
            }
            if (0 != (includedOptions & 2) && entry.isSmudged()) {
                sb.append(", smudged");
            }
            if (0 != (includedOptions & 4)) {
                sb.append(", length:" + Integer.toString(entry.getLength()));
            }
            if (0 != (includedOptions & 8)) {
                sb.append(", sha1:" + ObjectId.toString((ObjectId)entry.getObjectId()));
            }
            if (0 != (includedOptions & 0x10)) {
                sb.append(", content:" + new String(this.db.open((AnyObjectId)entry.getObjectId(), 3).getCachedBytes(), "UTF-8"));
            }
            if (0 != (includedOptions & 0x20)) {
                sb.append(", assume-unchanged:" + Boolean.toString(entry.isAssumeValid()));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String indexState(int includedOptions) throws IllegalStateException, IOException {
        return this.indexState((Repository)this.db, includedOptions);
    }

    protected void resetIndex(FileTreeIterator treeItr) throws FileNotFoundException, IOException {
        ObjectInserter inserter = this.db.newObjectInserter();
        DirCacheBuilder builder = this.db.lockDirCache().builder();
        while (!treeItr.eof()) {
            long len = treeItr.getEntryLength();
            DirCacheEntry dce = new DirCacheEntry(treeItr.getEntryPathString());
            dce.setFileMode(treeItr.getEntryFileMode());
            dce.setLastModified(treeItr.getEntryLastModified());
            dce.setLength((int)len);
            FileInputStream in = new FileInputStream(treeItr.getEntryFile());
            dce.setObjectId((AnyObjectId)inserter.insert(3, len, (InputStream)in));
            in.close();
            builder.add(dce);
            treeItr.next(1);
        }
        builder.commit();
        inserter.flush();
        inserter.release();
    }

    public static String lookup(Object l, String nameTemplate, Map<Object, String> lookupTable) {
        String name = lookupTable.get(l);
        if (name == null) {
            name = nameTemplate.replaceAll("%n", Integer.toString(lookupTable.size()));
            lookupTable.put(l, name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fsTick(File lastFile) throws InterruptedException, IOException {
        long sleepTime = 1L;
        FS fs = FS.DETECTED;
        if (lastFile != null && !fs.exists(lastFile)) {
            throw new FileNotFoundException(lastFile.getPath());
        }
        File tmp = File.createTempFile("FileTreeIteratorWithTimeControl", null);
        try {
            long startTime = lastFile == null ? fs.lastModified(tmp) : fs.lastModified(lastFile);
            long actTime = fs.lastModified(tmp);
            while (actTime <= startTime) {
                Thread.sleep(sleepTime);
                sleepTime *= 5L;
                fs.setLastModified(tmp, System.currentTimeMillis());
                actTime = fs.lastModified(tmp);
            }
            long l = actTime;
            return l;
        }
        finally {
            FileUtils.delete((File)tmp);
        }
    }

    protected void createBranch(ObjectId objectId, String branchName) throws IOException {
        RefUpdate updateRef = this.db.updateRef(branchName);
        updateRef.setNewObjectId((AnyObjectId)objectId);
        updateRef.update();
    }

    protected void checkoutBranch(String branchName) throws IllegalStateException, IOException {
        RevWalk walk = new RevWalk((Repository)this.db);
        RevCommit head = walk.parseCommit((AnyObjectId)this.db.resolve("HEAD"));
        RevCommit branch = walk.parseCommit((AnyObjectId)this.db.resolve(branchName));
        DirCacheCheckout dco = new DirCacheCheckout((Repository)this.db, head.getTree().getId(), this.db.lockDirCache(), branch.getTree().getId());
        dco.setFailOnConflict(true);
        dco.checkout();
        walk.release();
        RefUpdate refUpdate = this.db.updateRef("HEAD");
        refUpdate.setRefLogMessage("checkout: moving to " + branchName, false);
        refUpdate.link(branchName);
    }

    protected File writeTrashFiles(boolean ensureDistinctTimestamps, String ... contents) throws IOException, InterruptedException {
        File f = null;
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null) continue;
            if (ensureDistinctTimestamps && f != null) {
                RepositoryTestCase.fsTick(f);
            }
            f = this.writeTrashFile(Integer.toString(i), contents[i]);
        }
        return f;
    }

    protected RevCommit commitFile(String filename, String contents, String branch) {
        try {
            Git git = new Git((Repository)this.db);
            String originalBranch = git.getRepository().getFullBranch();
            if (git.getRepository().getRef(branch) == null) {
                git.branchCreate().setName(branch).call();
            }
            git.checkout().setName(branch).call();
            this.writeTrashFile(filename, contents);
            git.add().addFilepattern(filename).call();
            RevCommit commit = git.commit().setMessage(branch + ": " + filename).call();
            if (originalBranch != null) {
                git.checkout().setName(originalBranch).call();
            }
            return commit;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    protected DirCacheEntry createEntry(String path, FileMode mode) {
        return this.createEntry(path, mode, 0, path);
    }

    protected DirCacheEntry createEntry(String path, FileMode mode, String content) {
        return this.createEntry(path, mode, 0, content);
    }

    protected DirCacheEntry createEntry(String path, FileMode mode, int stage, String content) {
        DirCacheEntry entry = new DirCacheEntry(path, stage);
        entry.setFileMode(mode);
        entry.setObjectId((AnyObjectId)new ObjectInserter.Formatter().idFor(3, Constants.encode((String)content)));
        return entry;
    }
}

