/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.junit.JGitTestUtil;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class LocalDiskRepositoryTestCase {
    private static final boolean useMMAP = "true".equals(System.getProperty("jgit.junit.usemmap"));
    protected PersonIdent author;
    protected PersonIdent committer;
    protected MockSystemReader mockSystemReader;
    private final Set<Repository> toClose = new HashSet<Repository>();
    private File tmp;
    public static final int MOD_TIME = 1;
    public static final int SMUDGE = 2;
    public static final int LENGTH = 4;
    public static final int CONTENT_ID = 8;
    public static final int CONTENT = 16;
    public static final int ASSUME_UNCHANGED = 32;

    @Before
    public void setUp() throws Exception {
        this.tmp = File.createTempFile("jgit_test_", "_tmp");
        CleanupThread.deleteOnShutdown(this.tmp);
        if (!this.tmp.delete() || !this.tmp.mkdir()) {
            throw new IOException("Cannot create " + this.tmp);
        }
        this.mockSystemReader = new MockSystemReader();
        SystemReader.setInstance((SystemReader)this.mockSystemReader);
        FS.getFileStoreAttributes((Path)this.tmp.toPath().getParent());
        FileBasedConfig userConfig = new FileBasedConfig(new File(this.tmp, "usergitconfig"), FS.DETECTED);
        userConfig.setBoolean("gc", null, "autoDetach", false);
        userConfig.save();
        this.mockSystemReader.setUserGitConfig(userConfig);
        this.ceilTestDirectories(this.getCeilings());
        this.author = new PersonIdent("J. Author", "jauthor@example.com");
        this.committer = new PersonIdent("J. Committer", "jcommitter@example.com");
        WindowCacheConfig c = new WindowCacheConfig();
        c.setPackedGitLimit(131072L);
        c.setPackedGitWindowSize(8192);
        c.setPackedGitMMAP(useMMAP);
        c.setDeltaBaseCacheLimit(8192);
        c.install();
    }

    protected File getTemporaryDirectory() {
        return this.tmp.getAbsoluteFile();
    }

    protected List<File> getCeilings() {
        return Collections.singletonList(this.getTemporaryDirectory());
    }

    private void ceilTestDirectories(List<File> ceilings) {
        this.mockSystemReader.setProperty("GIT_CEILING_DIRECTORIES", LocalDiskRepositoryTestCase.makePath(ceilings));
    }

    private static String makePath(List<?> objects) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objects) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(object.toString());
        }
        return stringBuilder.toString();
    }

    @After
    public void tearDown() throws Exception {
        RepositoryCache.clear();
        for (Repository r : this.toClose) {
            r.close();
        }
        this.toClose.clear();
        if (useMMAP) {
            System.gc();
        }
        if (this.tmp != null) {
            LocalDiskRepositoryTestCase.recursiveDelete(this.tmp, false, true);
        }
        if (this.tmp != null && !this.tmp.exists()) {
            CleanupThread.removed(this.tmp);
        }
        SystemReader.setInstance(null);
    }

    protected void tick() {
        this.mockSystemReader.tick(300);
        long now = this.mockSystemReader.getCurrentTime();
        int tz = this.mockSystemReader.getTimezone(now);
        this.author = new PersonIdent(this.author, now, tz);
        this.committer = new PersonIdent(this.committer, now, tz);
    }

    protected void recursiveDelete(File dir) {
        LocalDiskRepositoryTestCase.recursiveDelete(dir, false, true);
    }

    private static boolean recursiveDelete(File dir, boolean silent, boolean failOnError) {
        assert (!silent || !failOnError);
        int options = 7;
        if (silent) {
            options |= 8;
        }
        try {
            FileUtils.delete((File)dir, (int)options);
        }
        catch (IOException e) {
            LocalDiskRepositoryTestCase.reportDeleteFailure(failOnError, dir, e);
            return !failOnError;
        }
        return true;
    }

    private static void reportDeleteFailure(boolean failOnError, File f, Exception cause) {
        String severity = failOnError ? "ERROR" : "WARNING";
        String msg = String.valueOf(severity) + ": Failed to delete " + f;
        if (failOnError) {
            Assert.fail((String)msg);
        } else {
            System.err.println(msg);
        }
        cause.printStackTrace(new PrintStream(System.err));
    }

    public static String indexState(Repository repo, int includedOptions) throws IllegalStateException, IOException {
        int i;
        DirCache dc = repo.readDirCache();
        StringBuilder sb = new StringBuilder();
        TreeSet<Instant> timeStamps = new TreeSet<Instant>();
        if ((includedOptions & 1) != 0) {
            i = 0;
            while (i < dc.getEntryCount()) {
                timeStamps.add(dc.getEntry(i).getLastModifiedInstant());
                ++i;
            }
        }
        i = 0;
        while (i < dc.getEntryCount()) {
            DirCacheEntry entry = dc.getEntry(i);
            sb.append("[" + entry.getPathString() + ", mode:" + entry.getFileMode());
            int stage = entry.getStage();
            if (stage != 0) {
                sb.append(", stage:" + stage);
            }
            if ((includedOptions & 1) != 0) {
                sb.append(", time:t" + timeStamps.headSet(entry.getLastModifiedInstant()).size());
            }
            if ((includedOptions & 2) != 0 && entry.isSmudged()) {
                sb.append(", smudged");
            }
            if ((includedOptions & 4) != 0) {
                sb.append(", length:" + Integer.toString(entry.getLength()));
            }
            if ((includedOptions & 8) != 0) {
                sb.append(", sha1:" + ObjectId.toString((ObjectId)entry.getObjectId()));
            }
            if ((includedOptions & 0x10) != 0) {
                sb.append(", content:" + new String(repo.open((AnyObjectId)entry.getObjectId(), 3).getCachedBytes(), StandardCharsets.UTF_8));
            }
            if ((includedOptions & 0x20) != 0) {
                sb.append(", assume-unchanged:" + Boolean.toString(entry.isAssumeValid()));
            }
            sb.append("]");
            ++i;
        }
        return sb.toString();
    }

    protected FileRepository createBareRepository() throws IOException {
        return this.createRepository(true);
    }

    protected FileRepository createWorkRepository() throws IOException {
        return this.createRepository(false);
    }

    protected FileRepository createRepository(boolean bare) throws IOException {
        return this.createRepository(bare, false);
    }

    @Deprecated
    public FileRepository createRepository(boolean bare, boolean autoClose) throws IOException {
        File gitdir = this.createUniqueTestGitDir(bare);
        FileRepository db = new FileRepository(gitdir);
        Assert.assertFalse((boolean)gitdir.exists());
        db.create(bare);
        if (autoClose) {
            this.addRepoToClose((Repository)db);
        }
        return db;
    }

    public void addRepoToClose(Repository r) {
        this.toClose.add(r);
    }

    protected File createTempDirectory(String name) throws IOException {
        File directory = new File(this.createTempFile(), name);
        FileUtils.mkdirs((File)directory);
        return directory.getCanonicalFile();
    }

    protected File createUniqueTestGitDir(boolean bare) throws IOException {
        String gitdirName = this.createTempFile().getPath();
        if (!bare) {
            gitdirName = String.valueOf(gitdirName) + "/";
        }
        return new File(String.valueOf(gitdirName) + ".git");
    }

    protected File createTempFile() throws IOException {
        File p = File.createTempFile("tmp_", "", this.tmp);
        if (!p.delete()) {
            throw new IOException("Cannot obtain unique path " + this.tmp);
        }
        return p;
    }

    protected int runHook(Repository db, File hook, String ... args) throws IOException, InterruptedException {
        String[] argv = new String[1 + args.length];
        argv[0] = hook.getAbsolutePath();
        System.arraycopy(args, 0, argv, 1, args.length);
        HashMap<String, String> env = LocalDiskRepositoryTestCase.cloneEnv();
        env.put("GIT_DIR", db.getDirectory().getAbsolutePath());
        LocalDiskRepositoryTestCase.putPersonIdent(env, "AUTHOR", this.author);
        LocalDiskRepositoryTestCase.putPersonIdent(env, "COMMITTER", this.committer);
        File cwd = db.getWorkTree();
        Process p = Runtime.getRuntime().exec(argv, LocalDiskRepositoryTestCase.toEnvArray(env), cwd);
        p.getOutputStream().close();
        p.getErrorStream().close();
        p.getInputStream().close();
        return p.waitFor();
    }

    private static void putPersonIdent(Map<String, String> env, String type, PersonIdent who) {
        String ident = who.toExternalString();
        String date = ident.substring(ident.indexOf("> ") + 2);
        env.put("GIT_" + type + "_NAME", who.getName());
        env.put("GIT_" + type + "_EMAIL", who.getEmailAddress());
        env.put("GIT_" + type + "_DATE", date);
    }

    protected File write(String body) throws IOException {
        File f = File.createTempFile("temp", "txt", this.tmp);
        try {
            this.write(f, body);
            return f;
        }
        catch (Error e) {
            f.delete();
            throw e;
        }
        catch (RuntimeException e) {
            f.delete();
            throw e;
        }
        catch (IOException e) {
            f.delete();
            throw e;
        }
    }

    protected void write(File f, String body) throws IOException {
        JGitTestUtil.write(f, body);
    }

    protected String read(File f) throws IOException {
        return JGitTestUtil.read(f);
    }

    private static String[] toEnvArray(Map<String, String> env) {
        String[] envp = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            envp[i++] = String.valueOf(e.getKey()) + "=" + e.getValue();
        }
        return envp;
    }

    private static HashMap<String, String> cloneEnv() {
        return new HashMap<String, String>(System.getenv());
    }

    private static final class CleanupThread
    extends Thread {
        private static final CleanupThread me = new CleanupThread();
        private final List<File> toDelete = new ArrayList<File>();

        static {
            Runtime.getRuntime().addShutdownHook(me);
        }

        private CleanupThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void deleteOnShutdown(File tmp) {
            CleanupThread cleanupThread = me;
            synchronized (cleanupThread) {
                CleanupThread.me.toDelete.add(tmp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removed(File tmp) {
            CleanupThread cleanupThread = me;
            synchronized (cleanupThread) {
                CleanupThread.me.toDelete.remove(tmp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.gc();
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                boolean silent = false;
                boolean failOnError = false;
                for (File tmp : this.toDelete) {
                    LocalDiskRepositoryTestCase.recursiveDelete(tmp, silent, failOnError);
                }
            }
        }
    }
}

