/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.junit.Repeat;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    private static Logger LOG = Logger.getLogger(RepeatRule.class.getName());

    public Statement apply(Statement statement, Description description) {
        Statement result = statement;
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            int n = repeat.n();
            result = new RepeatStatement(n, statement);
        }
        return result;
    }

    private static class RepeatStatement
    extends Statement {
        private final int repetitions;
        private final Statement statement;

        private RepeatStatement(int repetitions, Statement statement) {
            this.repetitions = repetitions;
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            int i = 0;
            while (i < this.repetitions) {
                try {
                    this.statement.evaluate();
                }
                catch (Throwable e) {
                    RepeatedTestException ex = new RepeatedTestException(MessageFormat.format("Repeated test failed when run for the {0}. time", i + 1), e);
                    LOG.log(Level.SEVERE, ex.getMessage(), ex);
                    throw ex;
                }
                ++i;
            }
        }
    }

    public static class RepeatedTestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RepeatedTestException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

