/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.util.time.MonotonicClock;
import org.eclipse.jgit.util.time.ProposedTimestamp;

public class MonotonicFakeClock
implements MonotonicClock {
    private long now = TimeUnit.SECONDS.toMicros(42L);

    public void tick(long add, TimeUnit unit) {
        if (add <= 0L) {
            throw new IllegalArgumentException();
        }
        this.now += unit.toMillis(add);
    }

    public ProposedTimestamp propose() {
        final long t = this.now++;
        return new ProposedTimestamp(){

            public long read(TimeUnit unit) {
                return unit.convert(t, TimeUnit.MILLISECONDS);
            }

            public void blockUntil(Duration maxWait) {
            }
        };
    }
}

