/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class FileUtils {
    public static final int NONE = 0;
    public static final int RECURSIVE = 1;
    public static final int RETRY = 2;
    public static final int SKIP_MISSING = 4;
    public static final int IGNORE_ERRORS = 8;
    public static final int EMPTY_DIRECTORIES_ONLY = 16;

    public static Path toPath(File f) throws IOException {
        try {
            return f.toPath();
        }
        catch (InvalidPathException ex) {
            throw new IOException(ex);
        }
    }

    public static void delete(File f) throws IOException {
        FileUtils.delete(f, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static void delete(File f, int options) throws IOException {
        fs = FS.DETECTED;
        if ((options & 4) != 0 && !fs.exists(f)) {
            return;
        }
        if ((options & 1) != 0 && fs.isDirectory(f) && (items = f.listFiles()) != null) {
            files = new ArrayList<File>();
            dirs = new ArrayList<File>();
            var9_7 = items;
            var8_8 = items.length;
            var7_9 = 0;
            while (var7_9 < var8_8) {
                c = var9_7[var7_9];
                if (c.isFile()) {
                    files.add(c);
                } else {
                    dirs.add(c);
                }
                ++var7_9;
            }
            for (File file : files) {
                FileUtils.delete(file, options);
            }
            for (File d : dirs) {
                FileUtils.delete(d, options);
            }
        }
        delete = false;
        if ((options & 16) != 0) {
            if (f.isDirectory()) {
                delete = true;
            } else if ((options & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, new Object[]{f.getAbsolutePath()}));
            }
        } else {
            delete = true;
        }
        if (delete) {
            block23: {
                t = null;
                p = f.toPath();
                try {
                    Files.delete(p);
                    return;
                }
                catch (FileNotFoundException e) {
                    if ((options & 12) == 0) {
                        throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, new Object[]{f.getAbsolutePath()}), e);
                    }
                    return;
                }
                catch (IOException e) {
                    t = e;
                    if ((options & 2) == 0) break block23;
                    i = 1;
                    ** while (i < 10)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var7_11) {
                        // empty catch block
                    }
                    try {
                        Files.deleteIfExists(p);
                        return;
                    }
                    catch (IOException e) {
                        t = e;
                        ++i;
                    }
                    continue;
                }
            }
            if ((options & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, new Object[]{f.getAbsolutePath()}), t);
            }
        }
    }

    public static void rename(File src, File dst) throws IOException {
        FileUtils.rename(src, dst, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void rename(File src, File dst, CopyOption ... options) throws AtomicMoveNotSupportedException, IOException {
        int attempts = FS.DETECTED.retryFailedLockFileCommit() ? 10 : 1;
        while (--attempts >= 0) {
            try {
                Files.move(FileUtils.toPath(src), FileUtils.toPath(dst), options);
                return;
            }
            catch (AtomicMoveNotSupportedException e) {
                throw e;
            }
            catch (IOException e) {
                try {
                    if (!dst.delete()) {
                        FileUtils.delete(dst, 17);
                    }
                    Files.move(FileUtils.toPath(src), FileUtils.toPath(dst), options);
                    return;
                }
                catch (IOException iOException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e2) {
                        throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()));
                    }
                }
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()));
    }

    public static void mkdir(File d) throws IOException {
        FileUtils.mkdir(d, false);
    }

    public static void mkdir(File d, boolean skipExisting) throws IOException {
        if (!d.mkdir()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirFailed, d.getAbsolutePath()));
        }
    }

    public static void mkdirs(File d) throws IOException {
        FileUtils.mkdirs(d, false);
    }

    public static void mkdirs(File d, boolean skipExisting) throws IOException {
        if (!d.mkdirs()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirsFailed, d.getAbsolutePath()));
        }
    }

    public static void createNewFile(File f) throws IOException {
        if (!f.createNewFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().createNewFileFailed, f));
        }
    }

    public static Path createSymLink(File path, String target) throws IOException {
        Path nioPath = FileUtils.toPath(path);
        if (Files.exists(nioPath, LinkOption.NOFOLLOW_LINKS)) {
            BasicFileAttributes attrs = Files.readAttributes(nioPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (attrs.isRegularFile() || attrs.isSymbolicLink()) {
                FileUtils.delete(path);
            } else {
                FileUtils.delete(path, 17);
            }
        }
        if (SystemReader.getInstance().isWindows()) {
            target = target.replace('/', '\\');
        }
        Path nioTarget = FileUtils.toPath(new File(target));
        return Files.createSymbolicLink(nioPath, nioTarget, new FileAttribute[0]);
    }

    public static String readSymLink(File path) throws IOException {
        Path nioPath = FileUtils.toPath(path);
        Path target = Files.readSymbolicLink(nioPath);
        String targetString = target.toString();
        if (SystemReader.getInstance().isWindows()) {
            targetString = targetString.replace('\\', '/');
        } else if (SystemReader.getInstance().isMacOS()) {
            targetString = Normalizer.normalize(targetString, Normalizer.Form.NFC);
        }
        return targetString;
    }

    public static File createTempDir(String prefix, String suffix, File dir) throws IOException {
        boolean RETRIES = true;
        int i = 0;
        while (i < 1) {
            File tmp = File.createTempFile(prefix, suffix, dir);
            if (tmp.delete() && tmp.mkdir()) {
                return tmp;
            }
            ++i;
        }
        throw new IOException(JGitText.get().cannotCreateTempDir);
    }

    public static String relativizeNativePath(String base, String other) {
        return FS.DETECTED.relativize(base, other);
    }

    public static String relativizeGitPath(String base, String other) {
        return FileUtils.relativizePath(base, other, "/", false);
    }

    public static String relativizePath(String base, String other, String dirSeparator, boolean caseSensitive) {
        if (base.equals(other)) {
            return "";
        }
        String[] baseSegments = base.split(Pattern.quote(dirSeparator));
        String[] otherSegments = other.split(Pattern.quote(dirSeparator));
        int commonPrefix = 0;
        while (commonPrefix < baseSegments.length && commonPrefix < otherSegments.length) {
            if (caseSensitive && baseSegments[commonPrefix].equals(otherSegments[commonPrefix])) {
                ++commonPrefix;
                continue;
            }
            if (caseSensitive || !baseSegments[commonPrefix].equalsIgnoreCase(otherSegments[commonPrefix])) break;
            ++commonPrefix;
        }
        StringBuilder builder = new StringBuilder();
        int i = commonPrefix;
        while (i < baseSegments.length) {
            builder.append("..").append(dirSeparator);
            ++i;
        }
        i = commonPrefix;
        while (i < otherSegments.length) {
            builder.append(otherSegments[i]);
            if (i < otherSegments.length - 1) {
                builder.append(dirSeparator);
            }
            ++i;
        }
        return builder.toString();
    }

    public static boolean isStaleFileHandle(IOException ioe) {
        String msg = ioe.getMessage();
        return msg != null && msg.toLowerCase(Locale.ROOT).matches("stale .*file .*handle");
    }

    public static boolean isStaleFileHandleInCausalChain(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof IOException && FileUtils.isStaleFileHandle((IOException)throwable)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    static boolean isSymlink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    static long lastModified(File file) throws IOException {
        return Files.getLastModifiedTime(FileUtils.toPath(file), LinkOption.NOFOLLOW_LINKS).toMillis();
    }

    static BasicFileAttributes fileAttributes(File file) throws IOException {
        return Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    static void setLastModified(File file, long time) throws IOException {
        Files.setLastModifiedTime(FileUtils.toPath(file), FileTime.fromMillis(time));
    }

    static boolean exists(File file) {
        return Files.exists(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    static boolean isHidden(File file) throws IOException {
        return Files.isHidden(FileUtils.toPath(file));
    }

    public static void setHidden(File file, boolean hidden) throws IOException {
        Files.setAttribute(FileUtils.toPath(file), "dos:hidden", hidden, LinkOption.NOFOLLOW_LINKS);
    }

    public static long getLength(File file) throws IOException {
        Path nioPath = FileUtils.toPath(file);
        if (Files.isSymbolicLink(nioPath)) {
            return Files.readSymbolicLink(nioPath).toString().getBytes(StandardCharsets.UTF_8).length;
        }
        return Files.size(nioPath);
    }

    static boolean isDirectory(File file) {
        return Files.isDirectory(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    static boolean isFile(File file) {
        return Files.isRegularFile(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean canExecute(File file) {
        if (!FileUtils.isFile(file)) {
            return false;
        }
        return Files.isExecutable(file.toPath());
    }

    static FS.Attributes getFileAttributesBasic(FS fs, File file) {
        try {
            Path nioPath = FileUtils.toPath(file);
            BasicFileAttributes readAttributes = nioPath.getFileSystem().provider().getFileAttributeView(nioPath, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            FS.Attributes attributes = new FS.Attributes(fs, file, true, readAttributes.isDirectory(), fs.supportsExecute() ? file.canExecute() : false, readAttributes.isSymbolicLink(), readAttributes.isRegularFile(), readAttributes.creationTime().toMillis(), readAttributes.lastModifiedTime().toMillis(), readAttributes.isSymbolicLink() ? (long)Constants.encode(FileUtils.readSymLink(file)).length : readAttributes.size());
            return attributes;
        }
        catch (IOException e) {
            return new FS.Attributes(file, fs);
        }
    }

    public static FS.Attributes getFileAttributesPosix(FS fs, File file) {
        try {
            Path nioPath = FileUtils.toPath(file);
            PosixFileAttributes readAttributes = nioPath.getFileSystem().provider().getFileAttributeView(nioPath, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            FS.Attributes attributes = new FS.Attributes(fs, file, true, readAttributes.isDirectory(), readAttributes.permissions().contains((Object)PosixFilePermission.OWNER_EXECUTE), readAttributes.isSymbolicLink(), readAttributes.isRegularFile(), readAttributes.creationTime().toMillis(), readAttributes.lastModifiedTime().toMillis(), readAttributes.size());
            return attributes;
        }
        catch (IOException e) {
            return new FS.Attributes(file, fs);
        }
    }

    public static File normalize(File file) {
        if (SystemReader.getInstance().isMacOS()) {
            String normalized = Normalizer.normalize(file.getPath(), Normalizer.Form.NFC);
            return new File(normalized);
        }
        return file;
    }

    public static String normalize(String name) {
        if (SystemReader.getInstance().isMacOS()) {
            if (name == null) {
                return null;
            }
            return Normalizer.normalize(name, Normalizer.Form.NFC);
        }
        return name;
    }

    public static File canonicalize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public static String pathToString(File file) {
        String path = file.getPath();
        if (SystemReader.getInstance().isWindows()) {
            return path.replace('\\', '/');
        }
        return path;
    }
}

