/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.buildpacks.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.service.buildpacks.BuildPackBuildOptions;
import org.eclipse.jkube.kit.service.buildpacks.BuildPackCommand;
import org.eclipse.jkube.kit.service.buildpacks.controller.BuildPackController;

public class BuildPackCliController
implements BuildPackController {
    private final File pack;
    private final KitLogger kitLogger;

    public BuildPackCliController(File binaryFile, KitLogger kitLogger) {
        this.pack = binaryFile;
        this.kitLogger = kitLogger;
    }

    @Override
    public void build(BuildPackBuildOptions buildOptions) {
        BuildPackCommand buildPackCommand = new BuildPackCommand(this.kitLogger, this.pack, this.createBuildCommandArguments(buildOptions), l -> this.kitLogger.info("[[s]]%s", new Object[]{l}));
        try {
            buildPackCommand.execute();
        }
        catch (IOException e) {
            throw new IllegalStateException("Process Existed With : " + buildPackCommand.getExitCode() + " [" + e.getMessage() + "]", e);
        }
    }

    @Override
    public String version() {
        AtomicReference versionRef = new AtomicReference();
        BuildPackCommand versionCommand = new BuildPackCommand(this.kitLogger, this.pack, Collections.singletonList("--version"), versionRef::set);
        try {
            versionCommand.execute();
        }
        catch (IOException e) {
            this.kitLogger.warn(e.getMessage(), new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)versionRef.get()))) {
            return (String)versionRef.get();
        }
        return null;
    }

    private List<String> createBuildCommandArguments(BuildPackBuildOptions buildOptions) {
        ArrayList<String> buildArgs = new ArrayList<String>();
        buildArgs.add("build");
        buildArgs.add(buildOptions.getImageName());
        buildArgs.addAll(Arrays.asList("--builder", buildOptions.getBuilderImage()));
        buildArgs.addAll(Arrays.asList("--creation-time", buildOptions.getCreationTime()));
        return buildArgs;
    }
}

