/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import org.eclipse.jkube.kit.build.api.assembly.AssemblyManager;
import org.eclipse.jkube.kit.build.service.docker.ArchiveService;
import org.eclipse.jkube.kit.build.service.docker.BuildService;
import org.eclipse.jkube.kit.build.service.docker.DockerAccessFactory;
import org.eclipse.jkube.kit.build.service.docker.QueryService;
import org.eclipse.jkube.kit.build.service.docker.RegistryService;
import org.eclipse.jkube.kit.build.service.docker.WatchService;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.common.KitLogger;

public class DockerServiceHub {
    private final DockerAccess dockerAccess;
    private final RegistryService registryService;
    private final BuildService buildService;
    private final ArchiveService archiveService;
    private final WatchService watchService;

    public static DockerServiceHub newInstance(KitLogger kitLogger) {
        return DockerServiceHub.newInstance(kitLogger, new DockerAccessFactory().createDockerAccess(DockerAccessFactory.DockerAccessContext.getDefault(kitLogger)));
    }

    public static DockerServiceHub newInstance(KitLogger kitLogger, DockerAccess dockerAccess) {
        return new DockerServiceHub(dockerAccess, AssemblyManager.getInstance(), kitLogger);
    }

    DockerServiceHub(DockerAccess dockerAccess, AssemblyManager assemblyManager, KitLogger logger) {
        this.dockerAccess = dockerAccess;
        this.archiveService = new ArchiveService(assemblyManager, logger);
        if (dockerAccess != null) {
            QueryService queryService = new QueryService(dockerAccess);
            this.registryService = new RegistryService(dockerAccess, queryService, logger);
            this.buildService = new BuildService(dockerAccess, queryService, this.registryService, this.archiveService, logger);
            this.watchService = new WatchService(this.archiveService, this.buildService, logger);
        } else {
            this.registryService = null;
            this.buildService = null;
            this.watchService = null;
        }
    }

    public DockerAccess getDockerAccess() {
        return this.dockerAccess;
    }

    public BuildService getBuildService() {
        this.checkDockerAccessInitialization();
        return this.buildService;
    }

    public RegistryService getRegistryService() {
        this.checkDockerAccessInitialization();
        return this.registryService;
    }

    public WatchService getWatchService() {
        this.checkDockerAccessInitialization();
        return this.watchService;
    }

    public ArchiveService getArchiveService() {
        return this.archiveService;
    }

    private synchronized void checkDockerAccessInitialization() {
        if (this.dockerAccess == null) {
            throw new IllegalStateException("Service hub created without a docker access to a docker daemon");
        }
    }
}

