/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jkube.kit.build.service.docker.access.DockerConnectionDetector;
import org.eclipse.jkube.kit.build.service.docker.config.DockerMachineConfiguration;
import org.eclipse.jkube.kit.build.service.docker.helper.EnvCommand;
import org.eclipse.jkube.kit.common.ExternalCommand;
import org.eclipse.jkube.kit.common.KitLogger;

public class DockerMachine
implements DockerConnectionDetector.DockerHostProvider {
    private final KitLogger log;
    private final DockerMachineConfiguration machine;
    private boolean initialized = false;
    private Map<String, String> envMap;

    public DockerMachine(KitLogger log, DockerMachineConfiguration machine) {
        this.log = log;
        this.machine = machine;
    }

    @Override
    public synchronized DockerConnectionDetector.ConnectionParameter getConnectionParameter(String certPath) throws IOException {
        String value;
        if (this.machine == null) {
            return null;
        }
        if (this.envMap == null) {
            this.envMap = this.getEnvironment();
        }
        if ((value = this.envMap.get("DOCKER_HOST")) == null) {
            return null;
        }
        this.log.info("DOCKER_HOST from docker-machine \"%s\" : %s", new Object[]{this.machine.getName(), value});
        return new DockerConnectionDetector.ConnectionParameter(value, certPath != null ? certPath : this.envMap.get("DOCKER_CERT_PATH"));
    }

    @Override
    public int getPriority() {
        return 90;
    }

    private Map<String, String> getEnvironment() throws IOException {
        this.lazyInit();
        return new MachineEnvCommand().getEnvironment();
    }

    private synchronized void lazyInit() throws IOException {
        if (!this.initialized) {
            Status status = new StatusCommand().getStatus();
            switch (status) {
                case DoesNotExist: {
                    if (Boolean.TRUE.equals(this.machine.getAutoCreate())) {
                        new CreateCommand().execute();
                        break;
                    }
                    throw new IllegalStateException(this.machine.getName() + " does not exist and docker.machine.autoCreate is false");
                }
                case Running: {
                    break;
                }
                case Stopped: {
                    new StartCommand().execute();
                    if (!Boolean.TRUE.equals(this.machine.getRegenerateCertsAfterStart())) break;
                    new RegenerateCertsCommand().execute();
                }
            }
        }
        this.initialized = true;
    }

    private class RegenerateCertsCommand
    extends ExternalCommand {
        private long start;

        RegenerateCertsCommand() {
            super(DockerMachine.this.log);
        }

        protected String[] getArgs() {
            return new String[]{"docker-machine", "regenerate-certs", "-f", DockerMachine.this.machine.getName()};
        }

        protected void start() {
            this.log.info("Regenerating certificates for \"%s\"", new Object[]{DockerMachine.this.machine.getName()});
            this.start = System.currentTimeMillis();
        }

        protected void end() {
            this.log.info("Regenerated certificates for \"%s\" in %d seconds", new Object[]{DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L});
        }
    }

    private class StartCommand
    extends ExternalCommand {
        private long start;

        StartCommand() {
            super(DockerMachine.this.log);
        }

        protected String[] getArgs() {
            return new String[]{"docker-machine", "start", DockerMachine.this.machine.getName()};
        }

        protected void start() {
            this.log.info("Starting docker machine \"%s\"", new Object[]{DockerMachine.this.machine.getName()});
            this.start = System.currentTimeMillis();
        }

        protected void end() {
            this.log.info("Started docker machine \"%s\" in %d seconds", new Object[]{DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L});
        }
    }

    private class CreateCommand
    extends ExternalCommand {
        private long start;

        CreateCommand() {
            super(DockerMachine.this.log);
        }

        protected String[] getArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("docker-machine");
            args.add("create");
            if (DockerMachine.this.machine.getCreateOptions() != null) {
                for (Map.Entry<String, String> entry : DockerMachine.this.machine.getCreateOptions().entrySet()) {
                    args.add("--" + entry.getKey());
                    String value = entry.getValue();
                    if (value == null || value.isEmpty()) continue;
                    args.add(value);
                }
            }
            args.add(DockerMachine.this.machine.getName());
            return args.toArray(new String[0]);
        }

        protected void start() {
            this.log.info("Creating docker machine \"%s\" with args %s", new Object[]{DockerMachine.this.machine.getName(), DockerMachine.this.machine.getCreateOptions() != null ? DockerMachine.this.machine.getCreateOptions().toString() : ""});
            this.log.info("This might take a while ...", new Object[0]);
            this.start = System.currentTimeMillis();
        }

        protected void end() {
            this.log.info("Created docker machine \"%s\" in %d seconds", new Object[]{DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L});
        }
    }

    private class StatusCommand
    extends ExternalCommand {
        private Status status;
        private String message;

        StatusCommand() {
            super(DockerMachine.this.log);
        }

        protected String[] getArgs() {
            return new String[]{"docker-machine", "status", DockerMachine.this.machine.getName()};
        }

        protected void processLine(String line) {
            this.log.info("Docker machine \"%s\" is %s", new Object[]{DockerMachine.this.machine.getName(), line.toLowerCase()});
            if ("Running".equals(line)) {
                this.status = Status.Running;
            } else if ("Stopped".equals(line)) {
                this.status = Status.Stopped;
            } else {
                this.message = "Unknown status - " + line;
            }
        }

        public Status getStatus() throws IOException {
            try {
                this.execute();
            }
            catch (IOException ex) {
                if (this.getStatusCode() == 1) {
                    this.status = Status.DoesNotExist;
                }
                throw ex;
            }
            if (this.message != null) {
                throw new IOException(this.message);
            }
            return this.status;
        }
    }

    private class MachineEnvCommand
    extends EnvCommand {
        MachineEnvCommand() {
            super(DockerMachine.this.log, "SET ");
        }

        protected String[] getArgs() {
            return new String[]{"docker-machine", "env", DockerMachine.this.machine.getName(), "--shell", "cmd"};
        }
    }

    static enum Status {
        DoesNotExist,
        Running,
        Stopped;

    }
}

