/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.RegistryConfig;

public class JKubeConfiguration
implements Serializable {
    private static final long serialVersionUID = 7459084747241070651L;
    private JavaProject project;
    private String sourceDirectory;
    private String outputDirectory;
    private Map<String, String> buildArgs;
    private RegistryConfig registryConfig;
    private List<JavaProject> reactorProjects;

    public File getBasedir() {
        return this.project.getBaseDirectory();
    }

    public Properties getProperties() {
        return this.project.getProperties();
    }

    public File inOutputDir(String path) {
        return this.inDir(this.getOutputDirectory(), path);
    }

    public File inSourceDir(String path) {
        return this.inDir(this.getSourceDirectory(), path);
    }

    public File inDir(String dir, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        File absoluteSourceDir = new File(this.getBasedir(), dir);
        return new File(absoluteSourceDir, path);
    }

    public static JKubeConfigurationBuilder builder() {
        return new JKubeConfigurationBuilder();
    }

    public JKubeConfigurationBuilder toBuilder() {
        return new JKubeConfigurationBuilder().project(this.project).sourceDirectory(this.sourceDirectory).outputDirectory(this.outputDirectory).buildArgs(this.buildArgs).registryConfig(this.registryConfig).reactorProjects(this.reactorProjects);
    }

    public JKubeConfiguration(JavaProject project, String sourceDirectory, String outputDirectory, Map<String, String> buildArgs, RegistryConfig registryConfig, List<JavaProject> reactorProjects) {
        this.project = project;
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
        this.buildArgs = buildArgs;
        this.registryConfig = registryConfig;
        this.reactorProjects = reactorProjects;
    }

    public JKubeConfiguration() {
    }

    public JavaProject getProject() {
        return this.project;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    public RegistryConfig getRegistryConfig() {
        return this.registryConfig;
    }

    public List<JavaProject> getReactorProjects() {
        return this.reactorProjects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JKubeConfiguration)) {
            return false;
        }
        JKubeConfiguration other = (JKubeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaProject this$project = this.getProject();
        JavaProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        String this$sourceDirectory = this.getSourceDirectory();
        String other$sourceDirectory = other.getSourceDirectory();
        if (this$sourceDirectory == null ? other$sourceDirectory != null : !this$sourceDirectory.equals(other$sourceDirectory)) {
            return false;
        }
        String this$outputDirectory = this.getOutputDirectory();
        String other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
            return false;
        }
        Map<String, String> this$buildArgs = this.getBuildArgs();
        Map<String, String> other$buildArgs = other.getBuildArgs();
        if (this$buildArgs == null ? other$buildArgs != null : !((Object)this$buildArgs).equals(other$buildArgs)) {
            return false;
        }
        RegistryConfig this$registryConfig = this.getRegistryConfig();
        RegistryConfig other$registryConfig = other.getRegistryConfig();
        if (this$registryConfig == null ? other$registryConfig != null : !((Object)this$registryConfig).equals(other$registryConfig)) {
            return false;
        }
        List<JavaProject> this$reactorProjects = this.getReactorProjects();
        List<JavaProject> other$reactorProjects = other.getReactorProjects();
        return !(this$reactorProjects == null ? other$reactorProjects != null : !((Object)this$reactorProjects).equals(other$reactorProjects));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JKubeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        String $sourceDirectory = this.getSourceDirectory();
        result = result * 59 + ($sourceDirectory == null ? 43 : $sourceDirectory.hashCode());
        String $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
        Map<String, String> $buildArgs = this.getBuildArgs();
        result = result * 59 + ($buildArgs == null ? 43 : ((Object)$buildArgs).hashCode());
        RegistryConfig $registryConfig = this.getRegistryConfig();
        result = result * 59 + ($registryConfig == null ? 43 : ((Object)$registryConfig).hashCode());
        List<JavaProject> $reactorProjects = this.getReactorProjects();
        result = result * 59 + ($reactorProjects == null ? 43 : ((Object)$reactorProjects).hashCode());
        return result;
    }

    public static class JKubeConfigurationBuilder {
        private JavaProject project;
        private String sourceDirectory;
        private String outputDirectory;
        private Map<String, String> buildArgs;
        private RegistryConfig registryConfig;
        private List<JavaProject> reactorProjects;

        JKubeConfigurationBuilder() {
        }

        public JKubeConfigurationBuilder project(JavaProject project) {
            this.project = project;
            return this;
        }

        public JKubeConfigurationBuilder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        public JKubeConfigurationBuilder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public JKubeConfigurationBuilder buildArgs(Map<String, String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        public JKubeConfigurationBuilder registryConfig(RegistryConfig registryConfig) {
            this.registryConfig = registryConfig;
            return this;
        }

        public JKubeConfigurationBuilder reactorProjects(List<JavaProject> reactorProjects) {
            this.reactorProjects = reactorProjects;
            return this;
        }

        public JKubeConfiguration build() {
            return new JKubeConfiguration(this.project, this.sourceDirectory, this.outputDirectory, this.buildArgs, this.registryConfig, this.reactorProjects);
        }

        public String toString() {
            return "JKubeConfiguration.JKubeConfigurationBuilder(project=" + this.project + ", sourceDirectory=" + this.sourceDirectory + ", outputDirectory=" + this.outputDirectory + ", buildArgs=" + this.buildArgs + ", registryConfig=" + this.registryConfig + ", reactorProjects=" + this.reactorProjects + ")";
        }
    }
}

