/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.Serialization;

public enum ResourceFileType {
    json("json", "json", Serialization::saveJson),
    yaml("yml", "yml", Serialization::saveYaml);

    private final String extension;
    private final String artifactType;
    private final Serializer serializer;

    private ResourceFileType(String extension, String artifactType, Serializer serializer) {
        this.extension = extension;
        this.artifactType = artifactType;
        this.serializer = serializer;
    }

    public File addExtensionIfMissing(File file) {
        String path = file.getAbsolutePath();
        if (!path.endsWith("." + this.extension)) {
            return new File(path + "." + this.extension);
        }
        return file;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public void serialize(File file, Object object) throws IOException {
        FileUtil.createDirectory(file.getParentFile());
        this.serializer.serialize(file, object);
    }

    public static ResourceFileType fromExtension(String ext) {
        try {
            return ResourceFileType.valueOf(ext);
        }
        catch (IllegalArgumentException exp) {
            for (ResourceFileType type : ResourceFileType.values()) {
                if (!type.extension.equals(ext)) continue;
                return type;
            }
            throw exp;
        }
    }

    public static ResourceFileType fromFile(File file) {
        String ext = FilenameUtils.getExtension((String)file.getPath());
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            return ResourceFileType.fromExtension(ext);
        }
        throw new IllegalArgumentException(String.format("Unsupported extension '%s' for file %s. Must be one of %s", ext, file, Arrays.asList(ResourceFileType.values())));
    }

    @FunctionalInterface
    public static interface Serializer {
        public void serialize(File var1, Object var2) throws IOException;
    }
}

