/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.client.http.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.common.util.okhttp.HttpHeaders;

public class Fabric8HttpUtil {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";

    private Fabric8HttpUtil() {
    }

    public static List<Map<String, String>> extractAuthenticationChallengeIntoMap(HttpResponse<?> response) throws IOException {
        return HttpHeaders.parseWwwAuthenticateChallengeHeaders(response.header(WWW_AUTHENTICATE));
    }

    public static String toFormData(Map<String, String> formData) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> e : formData.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(URLEncoder.encode(e.getKey(), StandardCharsets.UTF_8.name()));
            result.append("=");
            result.append(URLEncoder.encode(e.getValue(), StandardCharsets.UTF_8.name()));
        }
        return result.toString();
    }
}

