/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image.build;

import java.io.Serializable;
import java.util.Optional;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.config.image.build.HealthCheckMode;

public class HealthCheckConfiguration
implements Serializable {
    private static final long serialVersionUID = 3756852848945587001L;
    private HealthCheckMode mode;
    private String interval;
    private String timeout;
    private String startPeriod;
    private Integer retries;
    private Arguments cmd;

    public HealthCheckMode getMode() {
        return Optional.ofNullable(this.mode).orElse(HealthCheckMode.cmd);
    }

    public String getInterval() {
        return HealthCheckConfiguration.prepareTimeValue(this.interval);
    }

    public String getTimeout() {
        return HealthCheckConfiguration.prepareTimeValue(this.timeout);
    }

    public String getStartPeriod() {
        return HealthCheckConfiguration.prepareTimeValue(this.startPeriod);
    }

    private static String prepareTimeValue(String timeout) {
        if (timeout == null) {
            return null;
        }
        return timeout.matches("^\\d+$") ? timeout + "s" : timeout;
    }

    public void validate() {
        if (this.getMode() == null) {
            throw new IllegalArgumentException("HealthCheck: mode must not be null");
        }
        if (this.getMode() == HealthCheckMode.none) {
            if (this.interval != null || this.timeout != null || this.startPeriod != null || this.retries != null || this.cmd != null) {
                throw new IllegalArgumentException("HealthCheck: no parameters are allowed when the health check mode is set to 'none'");
            }
        } else if (this.getMode() == HealthCheckMode.cmd && this.cmd == null) {
            throw new IllegalArgumentException("HealthCheck: the parameter 'cmd' is mandatory when the health check mode is set to 'cmd' (default)");
        }
    }

    public static HealthCheckConfigurationBuilder builder() {
        return new HealthCheckConfigurationBuilder();
    }

    public HealthCheckConfiguration(HealthCheckMode mode, String interval, String timeout, String startPeriod, Integer retries, Arguments cmd) {
        this.mode = mode;
        this.interval = interval;
        this.timeout = timeout;
        this.startPeriod = startPeriod;
        this.retries = retries;
        this.cmd = cmd;
    }

    public HealthCheckConfiguration() {
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HealthCheckConfiguration)) {
            return false;
        }
        HealthCheckConfiguration other = (HealthCheckConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$retries = this.getRetries();
        Integer other$retries = other.getRetries();
        if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
            return false;
        }
        HealthCheckMode this$mode = this.getMode();
        HealthCheckMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        String this$startPeriod = this.getStartPeriod();
        String other$startPeriod = other.getStartPeriod();
        if (this$startPeriod == null ? other$startPeriod != null : !this$startPeriod.equals(other$startPeriod)) {
            return false;
        }
        Arguments this$cmd = this.getCmd();
        Arguments other$cmd = other.getCmd();
        return !(this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HealthCheckConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $retries = this.getRetries();
        result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
        HealthCheckMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        String $startPeriod = this.getStartPeriod();
        result = result * 59 + ($startPeriod == null ? 43 : $startPeriod.hashCode());
        Arguments $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        return result;
    }

    public static class HealthCheckConfigurationBuilder {
        private HealthCheckMode mode;
        private String interval;
        private String timeout;
        private String startPeriod;
        private Integer retries;
        private Arguments cmd;

        public HealthCheckConfigurationBuilder modeString(String modeString) {
            this.mode = Optional.ofNullable(modeString).map(HealthCheckMode::valueOf).orElse(null);
            return this;
        }

        HealthCheckConfigurationBuilder() {
        }

        public HealthCheckConfigurationBuilder mode(HealthCheckMode mode) {
            this.mode = mode;
            return this;
        }

        public HealthCheckConfigurationBuilder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public HealthCheckConfigurationBuilder timeout(String timeout) {
            this.timeout = timeout;
            return this;
        }

        public HealthCheckConfigurationBuilder startPeriod(String startPeriod) {
            this.startPeriod = startPeriod;
            return this;
        }

        public HealthCheckConfigurationBuilder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public HealthCheckConfigurationBuilder cmd(Arguments cmd) {
            this.cmd = cmd;
            return this;
        }

        public HealthCheckConfiguration build() {
            return new HealthCheckConfiguration(this.mode, this.interval, this.timeout, this.startPeriod, this.retries, this.cmd);
        }

        public String toString() {
            return "HealthCheckConfiguration.HealthCheckConfigurationBuilder(mode=" + (Object)((Object)this.mode) + ", interval=" + this.interval + ", timeout=" + this.timeout + ", startPeriod=" + this.startPeriod + ", retries=" + this.retries + ", cmd=" + this.cmd + ")";
        }
    }
}

