/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image.build;

public enum JKubeBuildStrategy {
    s2i("S2I", true),
    jib("Jib", true),
    docker("Docker", true),
    buildpacks("Buildpacks", false);

    private final String label;
    private final boolean supportsWatch;

    private JKubeBuildStrategy(String label, boolean supportsWatch) {
        this.label = label;
        this.supportsWatch = supportsWatch;
    }

    public boolean isSame(String type) {
        return type != null && (type.equalsIgnoreCase("source") && this == s2i || type.equalsIgnoreCase("docker") && this == docker);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isSupportsWatch() {
        return this.supportsWatch;
    }

    public static enum SourceStrategy {
        kind,
        namespace,
        name;


        public String key() {
            return this.name();
        }
    }
}

