/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.ingresscontroller;

import java.util.List;
import org.eclipse.jkube.kit.common.IngressControllerDetector;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;

public class IngressControllerDetectorManager {
    private static final String[] SERVICE_PATHS = new String[]{"META-INF/jkube/ingress-detectors"};
    private final KitLogger log;
    private final List<IngressControllerDetector> ingressControllerDetectors;

    public IngressControllerDetectorManager(JKubeServiceHub jKubeServiceHub) {
        this(jKubeServiceHub.getLog(), new PluginServiceFactory((Object)jKubeServiceHub.getClient(), new ClassLoader[0]).createServiceObjects(SERVICE_PATHS));
    }

    IngressControllerDetectorManager(KitLogger log, List<IngressControllerDetector> ingressControllerDetectors) {
        this.log = log;
        this.ingressControllerDetectors = ingressControllerDetectors;
    }

    public boolean detect() {
        boolean anyDetectorHadPermission = false;
        for (IngressControllerDetector detector : this.ingressControllerDetectors) {
            boolean permitted = detector.hasPermissions();
            anyDetectorHadPermission |= permitted;
            if (!permitted || !detector.isDetected()) continue;
            return true;
        }
        if (anyDetectorHadPermission) {
            this.log.warn("Ingress resources applied. However, no IngressController seems to be running at the moment, your service will most likely be not accessible.", new Object[0]);
        }
        return false;
    }
}

