/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.ingresscontroller;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.networking.v1.IngressClassList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.eclipse.jkube.kit.common.IngressControllerDetector;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;

public class KongIngressControllerDetector
implements IngressControllerDetector {
    private final KubernetesClient client;
    private static final String INGRESS_KONG_NAMESPACE = "kong";

    public KongIngressControllerDetector(KubernetesClient client) {
        this.client = client;
    }

    public boolean hasIngressClass() {
        return ((IngressClassList)this.client.network().v1().ingressClasses().list()).getItems().stream().anyMatch(i -> i.getSpec().getController().equals("ingress-controllers.konghq.com/kong"));
    }

    public boolean isIngressControllerReady() {
        return this.checkHelmInstallationAvailable() || this.checkManualInstallationAvailable();
    }

    public boolean hasPermissions() {
        return KubernetesHelper.hasAccessForAction((KubernetesClient)this.client, null, (String)"networking.k8s.io", (String)"ingressclasses", (String)"list") && KubernetesHelper.hasAccessForAction((KubernetesClient)this.client, null, null, (String)"pods", (String)"list");
    }

    private boolean checkManualInstallationAvailable() {
        return ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(INGRESS_KONG_NAMESPACE)).withLabel("app", "ingress-kong")).list()).getItems().stream().anyMatch(KubernetesHelper::isPodReady);
    }

    private boolean checkHelmInstallationAvailable() {
        return ((PodList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.client.pods().inAnyNamespace()).withLabel("app.kubernetes.io/name", INGRESS_KONG_NAMESPACE)).list()).getItems().stream().anyMatch(KubernetesHelper::isPodReady);
    }
}

