/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.TarImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyManager;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.helper.RegistryUtil;
import org.eclipse.jkube.kit.build.service.docker.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.service.AbstractImageBuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.service.jib.JibLogger;
import org.eclipse.jkube.kit.service.jib.JibServiceUtil;

public class JibBuildService
extends AbstractImageBuildService {
    private final KitLogger kitLogger;
    private final JibLogger jibLogger;
    private final AuthConfigFactory authConfigFactory;
    private final BuildServiceConfig buildServiceConfig;
    private final JKubeConfiguration configuration;

    public JibBuildService(JKubeServiceHub jKubeServiceHub) {
        this(jKubeServiceHub, new JibLogger(Objects.requireNonNull(jKubeServiceHub.getLog(), "Log is required")));
    }

    public JibBuildService(JKubeServiceHub jKubeServiceHub, JibLogger jibLogger) {
        super(jKubeServiceHub);
        this.jibLogger = jibLogger;
        this.kitLogger = jKubeServiceHub.getLog();
        this.authConfigFactory = new AuthConfigFactory(this.kitLogger);
        this.buildServiceConfig = Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "BuildServiceConfig is required");
        this.configuration = Objects.requireNonNull(jKubeServiceHub.getConfiguration(), "JKubeConfiguration is required");
    }

    @Override
    public boolean isApplicable() {
        return this.buildServiceConfig.getJKubeBuildStrategy() == JKubeBuildStrategy.jib;
    }

    @Override
    public void buildSingleImage(ImageConfiguration imageConfig) throws JKubeServiceException {
        try {
            this.kitLogger.info("[[B]]JIB[[B]] image build started", new Object[0]);
            if (imageConfig.getBuildConfiguration().isDockerFileMode()) {
                throw new JKubeServiceException("Dockerfile mode is not supported with JIB build strategy");
            }
            JibBuildService.prependRegistry(imageConfig, JibBuildService.getPushRegistry(imageConfig, this.configuration.getRegistryConfig()));
            BuildDirs buildDirs = new BuildDirs(imageConfig.getName(), this.configuration);
            String pullRegistry = JibBuildService.getPullRegistry(imageConfig, this.configuration.getRegistryConfig());
            Credential pullRegistryCredential = this.getRegistryCredentials(this.configuration.getRegistryConfig(), false, pullRegistry);
            JibContainerBuilder containerBuilder = JibServiceUtil.containerFromImageConfiguration((ImageConfiguration)imageConfig, (String)pullRegistry, (Credential)pullRegistryCredential);
            Map layers = AssemblyManager.getInstance().copyFilesToFinalTarballDirectory(this.configuration, buildDirs, AssemblyManager.getAssemblyConfiguration((BuildConfiguration)imageConfig.getBuildConfiguration(), (JKubeConfiguration)this.configuration));
            JibServiceUtil.layers((BuildDirs)buildDirs, (Map)layers).forEach(arg_0 -> ((JibContainerBuilder)containerBuilder).addFileEntriesLayer(arg_0));
            File dockerTarArchive = JibBuildService.getAssemblyTarArchive(imageConfig, this.configuration, this.kitLogger);
            JibServiceUtil.buildContainer((JibContainerBuilder)containerBuilder, (TarImage)TarImage.at((Path)dockerTarArchive.toPath()).named(imageConfig.getName()), (JibLogger)this.jibLogger);
            this.kitLogger.info(" %s successfully built", new Object[]{dockerTarArchive.getAbsolutePath()});
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new JKubeServiceException("Error when building JIB image", ex);
        }
    }

    @Override
    protected void pushSingleImage(ImageConfiguration imageConfiguration, int retries, RegistryConfig registryConfig, boolean skipTag) throws JKubeServiceException {
        try {
            String pushRegistry = JibBuildService.getPushRegistry(imageConfiguration, registryConfig);
            JibBuildService.prependRegistry(imageConfiguration, pushRegistry);
            this.kitLogger.info("This push refers to: %s", new Object[]{imageConfiguration.getName()});
            this.kitLogger.info("Pushing image: %s", new Object[]{new ImageName(imageConfiguration.getName()).getFullName()});
            JibServiceUtil.jibPush((ImageConfiguration)imageConfiguration, (Credential)this.getRegistryCredentials(registryConfig, true, pushRegistry), (File)JibBuildService.getBuildTarArchive(imageConfiguration, this.configuration), (JibLogger)this.jibLogger);
        }
        catch (Exception ex) {
            throw new JKubeServiceException("Error when push JIB image", ex);
        }
    }

    @Override
    public void postProcess() {
    }

    static ImageConfiguration prependRegistry(ImageConfiguration imageConfiguration, String registry) {
        ImageName imageName = new ImageName(imageConfiguration.getName());
        if (!imageName.hasRegistry() && registry != null) {
            imageConfiguration.setName(imageName.getFullName(registry));
            imageConfiguration.setRegistry(registry);
        }
        return imageConfiguration;
    }

    static File getAssemblyTarArchive(ImageConfiguration imageConfig, JKubeConfiguration configuration, KitLogger log) throws IOException {
        log.info("Preparing assembly files", new Object[0]);
        String targetImage = imageConfig.getName();
        return AssemblyManager.getInstance().createDockerTarArchive(targetImage, configuration, imageConfig.getBuildConfiguration(), log, null);
    }

    Credential getRegistryCredentials(RegistryConfig registryConfig, boolean isPush, String registry) throws IOException {
        AuthConfig standardAuthConfig = this.authConfigFactory.createAuthConfig(isPush, registryConfig.isSkipExtendedAuth(), registryConfig.getAuthConfig(), registryConfig.getSettings(), null, registry, registryConfig.getPasswordDecryptionMethod());
        Credential credentials = null;
        if (standardAuthConfig != null) {
            credentials = Credential.from((String)standardAuthConfig.getUsername(), (String)standardAuthConfig.getPassword());
        }
        return credentials;
    }

    static File getBuildTarArchive(ImageConfiguration imageConfiguration, JKubeConfiguration configuration) {
        BuildDirs buildDirs = new BuildDirs(imageConfiguration.getName(), configuration);
        return new File(buildDirs.getTemporaryRootDirectory(), "docker-build." + ArchiveCompression.none.getFileSuffix());
    }

    static String getPullRegistry(ImageConfiguration imageConfiguration, RegistryConfig registryConfig) {
        return RegistryUtil.getApplicablePullRegistryFrom((String)JibServiceUtil.getBaseImage((ImageConfiguration)imageConfiguration, null), (RegistryConfig)registryConfig);
    }

    static String getPushRegistry(ImageConfiguration imageConfiguration, RegistryConfig registryConfig) {
        return RegistryUtil.getApplicablePushRegistryFrom((ImageConfiguration)imageConfiguration, (RegistryConfig)registryConfig);
    }
}

