/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.plugins;

import java.io.File;
import java.io.IOException;
import org.eclipse.jkube.api.JKubePlugin;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.plugins.PluginService;

public class DefaultPluginService
implements PluginService {
    private final JKubeServiceHub jKubeServiceHub;

    public DefaultPluginService(JKubeServiceHub jKubeServiceHub) {
        this.jKubeServiceHub = jKubeServiceHub;
    }

    @Override
    public void addExtraFiles() throws JKubeServiceException {
        File extraDirectory = new File(this.jKubeServiceHub.getConfiguration().getProject().getOutputDirectory(), "jkube-extra");
        try {
            FileUtil.createDirectory((File)extraDirectory);
        }
        catch (IOException exception) {
            throw new JKubeServiceException("Unable to create the jkube-extra directory", exception);
        }
        for (JKubePlugin plugin : this.jKubeServiceHub.getPluginManager().getPlugins()) {
            this.jKubeServiceHub.getLog().debug("Adding extra files for plugin %s", new Object[]{plugin.getClass().getName()});
            try {
                plugin.addExtraFiles(extraDirectory);
                this.jKubeServiceHub.getLog().debug("Extra files for plugin %s added", new Object[]{plugin.getClass().getName()});
            }
            catch (Exception ex) {
                this.jKubeServiceHub.getLog().debug("Problem adding extra files for plugin %s: %s", new Object[]{plugin.getClass().getName(), ex.getMessage()});
            }
        }
    }
}

