/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.portforward;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.PodHelper;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;

public class PortForwardPodWatcher
implements Watcher<Pod> {
    private final KitLogger log;
    private final Map<String, String> envVars;
    private final CountDownLatch podReadyLatch;
    private final AtomicReference<Pod> foundPod;

    public PortForwardPodWatcher(KitLogger log, Map<String, String> envVars) {
        this.log = log;
        this.envVars = envVars;
        this.podReadyLatch = new CountDownLatch(1);
        this.foundPod = new AtomicReference<Object>(null);
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        this.log.info(KubernetesHelper.getName((HasMetadata)pod) + " status: " + KubernetesClientUtil.getPodStatusDescription(pod) + KubernetesClientUtil.getPodStatusMessagePostfix(action), new Object[0]);
        if (this.isAddOrModified(action) && KubernetesHelper.isPodRunning((Pod)pod) && KubernetesHelper.isPodReady((Pod)pod) && PodHelper.firstContainerHasEnvVars((Pod)pod, this.envVars)) {
            this.log.info("Debug Pod ready : %s", new Object[]{pod.getMetadata().getName()});
            this.foundPod.set(pod);
            this.podReadyLatch.countDown();
        }
    }

    public void onClose(WatcherException e) {
    }

    private boolean isAddOrModified(Watcher.Action action) {
        return action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED);
    }

    public Pod getFoundPod() {
        return this.foundPod.get();
    }

    public CountDownLatch getPodReadyLatch() {
        return this.podReadyLatch;
    }
}

