/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.specific;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;

public abstract class AbstractHealthCheckEnricher
extends BaseEnricher {
    public static final String ENRICH_CONTAINERS = "jkube.enricher.basic.enrichContainers";
    public static final String ENRICH_ALL_CONTAINERS = "jkube.enricher.basic.enrichAllContainers";

    public AbstractHealthCheckEnricher(EnricherContext buildContext, String name) {
        super(buildContext, name);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (this.skipHealthCheck(false)) {
            return;
        }
        for (ContainerBuilder container : this.getContainersToEnrich(builder)) {
            Probe probe;
            if (Boolean.FALSE.equals(container.hasReadinessProbe()) && (probe = this.getReadinessProbe(container)) != null) {
                this.log.info("Adding readiness " + this.describe(probe), new Object[0]);
                container.withReadinessProbe(probe);
            }
            if (Boolean.FALSE.equals(container.hasLivenessProbe()) && (probe = this.getLivenessProbe(container)) != null) {
                this.log.info("Adding liveness " + this.describe(probe), new Object[0]);
                container.withLivenessProbe(probe);
            }
            if (!Boolean.FALSE.equals(container.hasStartupProbe()) || (probe = this.getStartupProbe(container)) == null) continue;
            this.log.info("Adding startup " + this.describe(probe), new Object[0]);
            container.withStartupProbe(probe);
        }
    }

    private String describe(Probe probe) {
        StringBuilder desc = new StringBuilder("probe");
        if (probe.getHttpGet() != null) {
            desc.append(" on port ");
            desc.append(probe.getHttpGet().getPort().getIntVal());
            desc.append(", path='");
            desc.append(probe.getHttpGet().getPath());
            desc.append("'");
            desc.append(", scheme='");
            desc.append(probe.getHttpGet().getScheme());
            desc.append("'");
        }
        if (probe.getInitialDelaySeconds() != null) {
            desc.append(", with initial delay ");
            desc.append(probe.getInitialDelaySeconds());
            desc.append(" seconds");
        }
        if (probe.getPeriodSeconds() != null) {
            desc.append(", with period ");
            desc.append(probe.getPeriodSeconds());
            desc.append(" seconds");
        }
        return desc.toString();
    }

    private boolean skipHealthCheck(boolean defaultValue) {
        if (this.getContext().getProperty("jkube.skipHealthCheck") != null) {
            return Boolean.parseBoolean(this.getContext().getProperty("jkube.skipHealthCheck"));
        }
        return defaultValue;
    }

    protected List<ContainerBuilder> getContainersToEnrich(KubernetesListBuilder builder) {
        final LinkedList<ContainerBuilder> containerBuilders = new LinkedList<ContainerBuilder>();
        builder.accept(new Visitor[]{new TypedVisitor<ContainerBuilder>(){

            public void visit(ContainerBuilder containerBuilder) {
                containerBuilders.add(containerBuilder);
            }
        }});
        boolean enrichAllContainers = "true".equalsIgnoreCase(this.getConfig(Config.ENRICH_ALL_CONTAINERS));
        String enrichContainers = this.getConfig(Config.ENRICH_CONTAINERS);
        HashSet<String> containersToEnrich = new HashSet<String>();
        if (enrichContainers != null) {
            containersToEnrich.addAll(Arrays.asList(enrichContainers.split(",")));
        }
        if (enrichAllContainers) {
            return containerBuilders;
        }
        if (!containersToEnrich.isEmpty()) {
            LinkedList<ContainerBuilder> filteredContainers = new LinkedList<ContainerBuilder>();
            for (ContainerBuilder container : containerBuilders) {
                if (!container.hasName() || !containersToEnrich.contains(container.getName())) continue;
                filteredContainers.add(container);
            }
            return filteredContainers;
        }
        if (containerBuilders.size() == 1) {
            return containerBuilders;
        }
        LinkedList<ContainerBuilder> generatedContainers = new LinkedList<ContainerBuilder>();
        List fabric8GeneratedContainers = this.getProcessingInstructionViaKey("FABRIC8_GENERATED_CONTAINERS");
        for (ContainerBuilder container : containerBuilders) {
            if (!container.hasName() || !fabric8GeneratedContainers.contains(container.getName())) continue;
            generatedContainers.add(container);
        }
        return generatedContainers;
    }

    protected Probe getReadinessProbe(ContainerBuilder containerBuilder) {
        return this.getReadinessProbe();
    }

    protected Probe getReadinessProbe() {
        return null;
    }

    protected Probe getLivenessProbe(ContainerBuilder containerBuilder) {
        return this.getLivenessProbe();
    }

    protected Probe getLivenessProbe() {
        return null;
    }

    protected Probe getStartupProbe(ContainerBuilder containerBuilder) {
        return this.getStartupProbe();
    }

    protected Probe getStartupProbe() {
        return null;
    }

    private static enum Config implements Configs.Config
    {
        ENRICH_ALL_CONTAINERS("enrichAllContainers", "false"),
        ENRICH_CONTAINERS("enrichContainers", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

