/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.openliberty.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.FatJarDetector;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class OpenLibertyGenerator
extends JavaExecGenerator {
    private static final String LIBERTY_SELF_EXTRACTOR = "wlp.lib.extract.SelfExtractRun";
    private static final String LIBERTY_RUNNABLE_JAR = "LIBERTY_RUNNABLE_JAR";
    private static final String JAVA_APP_JAR = "JAVA_APP_JAR";

    public OpenLibertyGenerator(GeneratorContext context) {
        super(context, "openliberty");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && (JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"io.openliberty.tools", (String)"liberty-maven-plugin") || JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"io.openliberty.tools.gradle.Liberty", (String)"io.openliberty.tools.gradle.Liberty.gradle.plugin") || JKubeProjectUtil.hasGradlePlugin((JavaProject)this.getProject(), (String)"io.openliberty.tools.gradle.Liberty"));
    }

    protected String getDefaultWebPort() {
        return "9080";
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        Map ret = super.getEnv(prePackagePhase);
        FatJarDetector.Result fatJar = this.detectFatJar();
        if (fatJar != null && LIBERTY_SELF_EXTRACTOR.equals(fatJar.getMainClass())) {
            ret.put(LIBERTY_RUNNABLE_JAR, fatJar.getArchiveFile().getName());
            ret.put(JAVA_APP_JAR, fatJar.getArchiveFile().getName());
        }
        return ret;
    }

    public List<AssemblyFileSet> addAdditionalFiles() {
        ArrayList<AssemblyFileSet> fileSets = new ArrayList<AssemblyFileSet>();
        fileSets.add(OpenLibertyGenerator.createFileSet((String)"src/main/jkube-includes/bin", (String)"bin", (String)"0755"));
        fileSets.add(OpenLibertyGenerator.createFileSet((String)"src/main/jkube-includes", (String)".", (String)"0644"));
        fileSets.add(OpenLibertyGenerator.createFileSet((String)"src/main/liberty/config", (String)"src/wlp/config", (String)"0644"));
        return fileSets;
    }
}

