/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.profile;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JKubeException;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.profile.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileUtil {
    private static final Logger log = LoggerFactory.getLogger(ProfileUtil.class);
    private static final String[] PROFILE_FILENAMES = new String[]{"profiles%s.yml", "profiles%s.yaml", "profiles%s"};
    public static final String DEFAULT_PROFILE = "default";
    public static final ProcessorConfigurationExtractor GENERATOR_CONFIG = Profile::getGeneratorConfig;
    public static final ProcessorConfigurationExtractor ENRICHER_CONFIG = Profile::getEnricherConfig;
    public static final ProcessorConfigurationExtractor WATCHER_CONFIG = Profile::getWatcherConfig;

    private ProfileUtil() {
    }

    public static Profile findProfile(String profileArg, List<File> resourceDirs) {
        return ProfileUtil.findProfile(profileArg, resourceDirs == null ? new File[]{} : resourceDirs.toArray(new File[0]));
    }

    public static Profile findProfile(String profileArg, File ... resourceDirs) {
        String profile = profileArg == null ? DEFAULT_PROFILE : profileArg;
        for (File resourceDir : resourceDirs) {
            try {
                Profile profileFound = ProfileUtil.lookup(profile, resourceDir);
                if (profileFound == null) continue;
                if (profileFound.getParentProfile() != null) {
                    profileFound = ProfileUtil.inheritFromParentProfile(profileFound, resourceDir);
                    log.info("{} inheriting resources from {}", (Object)profileFound, (Object)profileFound.getParentProfile());
                }
                return profileFound;
            }
            catch (IOException ioException) {
                throw JKubeException.launderThrowable((String)("Error in looking up profile in " + resourceDir.getAbsolutePath()), (Throwable)ioException);
            }
        }
        throw new IllegalArgumentException("No profile '" + profile + "' defined");
    }

    private static Profile inheritFromParentProfile(Profile aProfile, File resourceDir) throws IOException {
        Profile aParentProfile = ProfileUtil.lookup(aProfile.getParentProfile(), resourceDir);
        if (aParentProfile == null) {
            throw new IllegalArgumentException("No parent profile '" + aProfile.getParentProfile() + "' defined");
        }
        aProfile.setEnricherConfig(ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{aProfile.getEnricherConfig(), aParentProfile.getEnricherConfig()}));
        aProfile.setGeneratorConfig(ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{aProfile.getGeneratorConfig(), aParentProfile.getGeneratorConfig()}));
        aProfile.setWatcherConfig(ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{aProfile.getWatcherConfig(), aParentProfile.getWatcherConfig()}));
        return aProfile;
    }

    public static ProcessorConfig blendProfileWithConfiguration(ProcessorConfigurationExtractor configExtractor, String profile, List<File> resourceDirs, ProcessorConfig config) {
        ProcessorConfig profileConfig = ProfileUtil.extractProcessorConfiguration(configExtractor, profile, resourceDirs);
        return ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{config, profileConfig});
    }

    public static Profile lookup(String name, File directory) throws IOException {
        List<Profile> profiles = ProfileUtil.readProfileFromClasspath(name);
        File profileFile = ProfileUtil.findProfileYaml(directory);
        if (profileFile != null) {
            for (Profile profile : (List)Serialization.unmarshal((File)profileFile, (TypeReference)new TypeReference<List<Profile>>(){})) {
                if (!profile.getName().equals(name)) continue;
                profiles.add(profile);
                break;
            }
        }
        profiles.sort(Collections.reverseOrder());
        return ProfileUtil.mergeProfiles(profiles);
    }

    private static ProcessorConfig extractProcessorConfiguration(ProcessorConfigurationExtractor extractor, String profile, List<File> resourceDirs) {
        Profile profileFound = ProfileUtil.findProfile(profile, resourceDirs);
        return extractor.extract(profileFound);
    }

    private static Profile mergeProfiles(List<Profile> profiles) {
        Profile ret = null;
        for (Profile profile : profiles) {
            if (profile == null) continue;
            if (ret == null) {
                ret = new Profile(profile);
                continue;
            }
            ret = new Profile(ret, profile);
        }
        return ret;
    }

    private static List<Profile> readProfileFromClasspath(String name) throws IOException {
        ArrayList<Profile> ret = new ArrayList<Profile>();
        ret.addAll(ProfileUtil.readAllFromClasspath(name, DEFAULT_PROFILE));
        ret.addAll(ProfileUtil.readAllFromClasspath(name, ""));
        return ret;
    }

    public static List<Profile> readAllFromClasspath(String name, String ext) throws IOException {
        ArrayList<Profile> ret = new ArrayList<Profile>();
        for (String location : ProfileUtil.getMetaInfProfilePaths(ext)) {
            for (String url : ClassUtil.getResources((String)location)) {
                for (Profile profile : (List)Serialization.unmarshal((URL)new URL(url), (TypeReference)new TypeReference<List<Profile>>(){})) {
                    if (!name.equals(profile.getName())) continue;
                    ret.add(profile);
                }
            }
        }
        return ret;
    }

    private static File findProfileYaml(File directory) {
        for (String profileFile : PROFILE_FILENAMES) {
            File ret = new File(directory, String.format(profileFile, ""));
            if (!ret.exists()) continue;
            return ret;
        }
        return null;
    }

    private static List<String> getMetaInfProfilePaths(String ext) {
        ArrayList<String> ret = new ArrayList<String>(PROFILE_FILENAMES.length);
        for (String p : PROFILE_FILENAMES) {
            ret.add("META-INF/jkube/" + ProfileUtil.getProfileFileName(p, ext));
        }
        return ret;
    }

    private static String getProfileFileName(String fileName, String ext) {
        return String.format(fileName, StringUtils.isNotBlank((CharSequence)ext) ? "-" + ext : "");
    }

    public static interface ProcessorConfigurationExtractor {
        public ProcessorConfig extract(Profile var1);
    }
}

