/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.enricher;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.SpringBootConfiguration;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class SpringBootHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public static final String ENRICHER_NAME = "jkube-healthcheck-spring-boot";
    protected static final String[] REQUIRED_CLASSES = new String[]{"org.springframework.boot.actuate.health.HealthIndicator", "org.springframework.web.context.support.GenericWebApplicationContext"};
    private static final String SCHEME_HTTPS = "HTTPS";
    private static final String SCHEME_HTTP = "HTTP";

    public SpringBootHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    protected Probe getReadinessProbe() {
        Integer initialDelay = Configs.asInteger((String)this.getConfig(Config.READINESS_PROBE_INITIAL_DELAY_SECONDS));
        Integer period = Configs.asInteger((String)this.getConfig(Config.READINESS_PROBE_PERIOD_SECONDS));
        Integer timeout = Configs.asInteger((String)this.getConfig(Config.TIMEOUT_SECONDS));
        Integer failureThreshold = Configs.asInteger((String)this.getConfig(Config.FAILURE_THRESHOLD));
        Integer successThreshold = Configs.asInteger((String)this.getConfig(Config.SUCCESS_THRESHOLD));
        return this.discoverSpringBootHealthCheck(initialDelay, period, timeout, failureThreshold, successThreshold);
    }

    protected Probe getLivenessProbe() {
        Integer initialDelay = Configs.asInteger((String)this.getConfig(Config.LIVENESS_PROBE_INITIAL_DELAY_SECONDS));
        Integer period = Configs.asInteger((String)this.getConfig(Config.LIVENESS_PROBE_PERIOD_SECONDS));
        Integer timeout = Configs.asInteger((String)this.getConfig(Config.TIMEOUT_SECONDS));
        Integer failureThreshold = Configs.asInteger((String)this.getConfig(Config.FAILURE_THRESHOLD));
        Integer successThreshold = Configs.asInteger((String)this.getConfig(Config.SUCCESS_THRESHOLD));
        return this.discoverSpringBootHealthCheck(initialDelay, period, timeout, failureThreshold, successThreshold);
    }

    protected Probe discoverSpringBootHealthCheck(Integer initialDelay, Integer period, Integer timeout, Integer failureTh, Integer successTh) {
        try {
            if (this.getContext().getProjectClassLoaders().isClassInCompileClasspath(true, REQUIRED_CLASSES)) {
                return this.buildProbe(initialDelay, period, timeout, failureTh, successTh);
            }
        }
        catch (Exception ex) {
            this.log.error("Error while reading the spring-boot configuration", new Object[]{ex});
        }
        return null;
    }

    protected Probe buildProbe(Integer initialDelay, Integer period, Integer timeout, Integer failureTh, Integer successTh) {
        String prefix;
        String scheme;
        SpringBootConfiguration springBootConfiguration = SpringBootConfiguration.from((JavaProject)this.getContext().getProject());
        Integer managementPort = springBootConfiguration.getManagementPort();
        boolean usingManagementPort = managementPort != null;
        Integer port = managementPort;
        if (port == null) {
            port = springBootConfiguration.getServerPort();
        }
        if (usingManagementPort) {
            scheme = StringUtils.isNotBlank((CharSequence)springBootConfiguration.getManagementKeystore()) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = StringUtils.isNotBlank((CharSequence)springBootConfiguration.getManagementContextPath()) ? springBootConfiguration.getManagementContextPath() : "";
        } else {
            scheme = StringUtils.isNotBlank((CharSequence)springBootConfiguration.getServerKeystore()) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = StringUtils.isNotBlank((CharSequence)springBootConfiguration.getServerContextPath()) ? springBootConfiguration.getServerContextPath() : "";
            prefix = prefix + (StringUtils.isNotBlank((CharSequence)springBootConfiguration.getServletPath()) ? springBootConfiguration.getServletPath() : "");
            prefix = prefix + (StringUtils.isNotBlank((CharSequence)springBootConfiguration.getManagementContextPath()) ? springBootConfiguration.getManagementContextPath() : "");
        }
        String actuatorBasePath = springBootConfiguration.getActuatorDefaultBasePath();
        if (StringUtils.isNotBlank((CharSequence)springBootConfiguration.getActuatorBasePath())) {
            actuatorBasePath = springBootConfiguration.getActuatorBasePath();
        }
        ProbeBuilder probeBuilder = (ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort((Object)port)).withPath(this.normalizeMultipleSlashes(prefix + actuatorBasePath + Configs.asString((String)this.getConfig(Config.PATH))))).withScheme(scheme)).endHttpGet();
        if (initialDelay != null) {
            probeBuilder = (ProbeBuilder)probeBuilder.withInitialDelaySeconds(initialDelay);
        }
        if (period != null) {
            probeBuilder = (ProbeBuilder)probeBuilder.withPeriodSeconds(period);
        }
        if (timeout != null) {
            probeBuilder.withTimeoutSeconds(timeout);
        }
        if (failureTh != null) {
            probeBuilder.withFailureThreshold(failureTh);
        }
        if (successTh != null) {
            probeBuilder.withSuccessThreshold(successTh);
        }
        return probeBuilder.build();
    }

    private String normalizeMultipleSlashes(String s) {
        return s.replaceAll("/{2,}", "/");
    }

    private static enum Config implements Configs.Config
    {
        READINESS_PROBE_INITIAL_DELAY_SECONDS("readinessProbeInitialDelaySeconds", "10"),
        READINESS_PROBE_PERIOD_SECONDS("readinessProbePeriodSeconds", null),
        PATH("path", "/health"),
        LIVENESS_PROBE_INITIAL_DELAY_SECONDS("livenessProbeInitialDelaySeconds", "180"),
        LIVENESS_PROBE_PERIOD_SECONDS("livenessProbePeriodSeconds", null),
        FAILURE_THRESHOLD("failureThreshold", "3"),
        SUCCESS_THRESHOLD("successThreshold", "1"),
        TIMEOUT_SECONDS("timeoutSeconds", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

