/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.maven.plugin.mojo.build.HelmMojo;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class OpenshiftHelmMojo
extends HelmMojo {
    @Parameter(property="jkube.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/openshift.yml")
    private File openShiftManifest;
    @Parameter(property="jkube.openshiftTemplate", defaultValue="${basedir}/target/classes/META-INF/jkube/openshift")
    private File openShiftTemplate;

    protected File getKubernetesManifest() {
        return this.openShiftManifest;
    }

    protected File getKubernetesTemplate() {
        return this.openShiftTemplate;
    }

    protected HelmConfig.HelmType getDefaultHelmType() {
        return HelmConfig.HelmType.OPENSHIFT;
    }

    protected String getLogPrefix() {
        return "oc: ";
    }

    protected void logManifestNotFoundWarning(File manifest) {
        this.getKitLogger().warn("No OpenShift manifest file has been generated yet by the oc:resource goal at: " + manifest, new Object[0]);
    }
}

