/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.yum;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.packagedrone.utils.io.OutputSpooler;
import org.eclipse.packagedrone.utils.io.SpoolOutTarget;
import org.eclipse.packagedrone.utils.rpm.HashAlgorithm;
import org.eclipse.packagedrone.utils.rpm.RpmVersion;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.eclipse.packagedrone.utils.rpm.info.RpmInformation;
import org.eclipse.packagedrone.utils.security.pgp.SigningStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RepositoryCreator {
    private static final String MD_NAME = "SHA-256";
    private static final String MD_TAG = "sha256";
    private final XmlContext xml;
    private final OutputSpooler primaryStreamBuilder;
    private final OutputSpooler filelistsStreamBuilder;
    private final OutputSpooler otherStreamBuilder;
    private final OutputSpooler mdStreamBuilder;
    private final List<Pattern> primaryFiles;
    private final List<Pattern> primaryDirs;
    private final String primaryUniqueName;
    private final String filelistsUniqueName;
    private final String otherUniqueName;

    private RepositoryCreator(SpoolOutTarget target, XmlContext xml, Function<OutputStream, OutputStream> signingStreamCreator) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(xml);
        this.xml = xml;
        String dirFilter = System.getProperty("drone.rpm.yum.primaryDirs", "bin/,^/etc/");
        String fileFilter = System.getProperty("drone.rpm.yum.primaryFiles", dirFilter);
        this.primaryFiles = Arrays.stream(fileFilter.split(",")).map(re -> Pattern.compile(re)).collect(Collectors.toList());
        this.primaryDirs = Arrays.stream(dirFilter.split(",")).map(re -> Pattern.compile(re)).collect(Collectors.toList());
        this.primaryUniqueName = UUID.randomUUID().toString().replace("-", "");
        this.filelistsUniqueName = UUID.randomUUID().toString().replace("-", "");
        this.otherUniqueName = UUID.randomUUID().toString().replace("-", "");
        this.primaryStreamBuilder = new OutputSpooler(target);
        this.primaryStreamBuilder.addDigest(MD_NAME);
        this.primaryStreamBuilder.addOutput(String.format("repodata/%s-primary.xml", this.primaryUniqueName), "application/xml");
        this.primaryStreamBuilder.addOutput(String.format("repodata/%s-primary.xml.gz", this.primaryUniqueName), "application/x-gzip", output -> new GZIPOutputStream((OutputStream)output));
        this.filelistsStreamBuilder = new OutputSpooler(target);
        this.filelistsStreamBuilder.addDigest(MD_NAME);
        this.filelistsStreamBuilder.addOutput(String.format("repodata/%s-filelists.xml", this.filelistsUniqueName), "application/xml");
        this.filelistsStreamBuilder.addOutput(String.format("repodata/%s-filelists.xml.gz", this.filelistsUniqueName), "application/x-gzip", output -> new GZIPOutputStream((OutputStream)output));
        this.otherStreamBuilder = new OutputSpooler(target);
        this.otherStreamBuilder.addDigest(MD_NAME);
        this.otherStreamBuilder.addOutput(String.format("repodata/%s-other.xml", this.otherUniqueName), "application/xml");
        this.otherStreamBuilder.addOutput(String.format("repodata/%s-other.xml.gz", this.otherUniqueName), "application/x-gzip", output -> new GZIPOutputStream((OutputStream)output));
        this.mdStreamBuilder = new OutputSpooler(target);
        this.mdStreamBuilder.addOutput("repodata/repomd.xml", "application/xml");
        if (signingStreamCreator != null) {
            this.mdStreamBuilder.addOutput("repodata/repomd.xml.asc", "text/plain", signingStreamCreator::apply);
        }
    }

    private boolean matches(String pathName, List<Pattern> filterList) {
        for (Pattern p : filterList) {
            if (!p.matcher(pathName).find()) continue;
            return true;
        }
        return false;
    }

    public void process(IOConsumer<Context> consumer) throws IOException {
        long now = System.currentTimeMillis();
        this.primaryStreamBuilder.open(primaryStream -> this.filelistsStreamBuilder.open(filelistsStream -> this.otherStreamBuilder.open(otherStream -> {
            ContextImpl ctx = this.makeContext((OutputStream)primaryStream, (OutputStream)filelistsStream, (OutputStream)otherStream);
            consumer.accept((Object)ctx);
            ctx.close();
        })));
        this.mdStreamBuilder.open(stream -> this.writeRepoMd((OutputStream)stream, now));
    }

    private ContextImpl makeContext(OutputStream primaryStream, OutputStream filelistsStream, OutputStream otherStream) {
        return new ContextImpl(primaryStream, filelistsStream, otherStream, this.xml);
    }

    private void writeRepoMd(OutputStream stream, long now) throws IOException {
        Document doc = this.xml.createDocument();
        Element root = doc.createElementNS("http://linux.duke.edu/metadata/repo", "repomd");
        doc.appendChild(root);
        root.setAttribute("revision", Long.toString(now / 1000L));
        this.addDataFile(root, this.primaryStreamBuilder, this.primaryUniqueName, "primary", now);
        this.addDataFile(root, this.filelistsStreamBuilder, this.filelistsUniqueName, "filelists", now);
        this.addDataFile(root, this.otherStreamBuilder, this.otherUniqueName, "other", now);
        try {
            this.xml.write(doc, stream);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void addDataFile(Element root, OutputSpooler spooler, String unique, String baseName, long now) {
        String filename = "repodata/" + unique + "-" + baseName + ".xml";
        Element data = RepositoryCreator.addElement(root, "data");
        data.setAttribute("type", baseName);
        Element checksum = RepositoryCreator.addElement(data, "checksum", spooler.getChecksum(filename + ".gz", MD_NAME));
        checksum.setAttribute("type", MD_TAG);
        Element openChecksum = RepositoryCreator.addElement(data, "open-checksum", spooler.getChecksum(filename, MD_NAME));
        openChecksum.setAttribute("type", MD_TAG);
        Element location = RepositoryCreator.addElement(data, "location");
        location.setAttribute("href", filename + ".gz");
        RepositoryCreator.addElement(data, "timestamp", now / 1000L);
        RepositoryCreator.addElement(data, "size", "" + spooler.getSize(filename + ".gz"));
        RepositoryCreator.addElement(data, "open-size", "" + spooler.getSize(filename));
    }

    private static void addOptionalElement(Element parent, String name, Object value) {
        if (value == null) {
            return;
        }
        RepositoryCreator.addElement(parent, name, value);
    }

    private static Element addElement(Element parent, String name) {
        return RepositoryCreator.addElement(parent, name, null);
    }

    private static Element addElement(Element parent, String name, Object value) {
        Document doc = parent.getOwnerDocument();
        Element result = doc.createElement(name);
        parent.appendChild(result);
        if (value != null) {
            result.appendChild(doc.createTextNode(value.toString()));
        }
        return result;
    }

    public static class Builder {
        private SpoolOutTarget target;
        private XmlContext xmlContext;
        private Function<OutputStream, OutputStream> signingStreamCreator;

        public Builder setTarget(SpoolOutTarget target) {
            this.target = target;
            return this;
        }

        public Builder setXmlContext(XmlContext xmlContext) {
            this.xmlContext = xmlContext;
            return this;
        }

        public Builder setSigning(Function<OutputStream, OutputStream> signingStreamCreator) {
            this.signingStreamCreator = signingStreamCreator;
            return this;
        }

        public Builder setSigning(PGPPrivateKey privateKey) {
            return this.setSigning(privateKey, 2);
        }

        public Builder setSigning(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm) {
            return this.setSigning(privateKey, hashAlgorithm.getValue());
        }

        public Builder setSigning(PGPPrivateKey privateKey, int digestAlgorithm) {
            this.signingStreamCreator = privateKey != null ? output -> new SigningStream(output, privateKey, digestAlgorithm, false) : null;
            return this;
        }

        public RepositoryCreator build() {
            return new RepositoryCreator(this.target, this.xmlContext == null ? new DefaultXmlContext() : this.xmlContext, this.signingStreamCreator);
        }
    }

    private class ContextImpl
    implements Context {
        private final OutputStream primaryStream;
        private final OutputStream filelistsStream;
        private final OutputStream otherStream;
        private final XmlContext xml;
        private final Document primary;
        private final Document filelists;
        private final Document other;
        private final Element primaryRoot;
        private final Element filelistsRoot;
        private final Element otherRoot;
        private long count;

        public ContextImpl(OutputStream primaryStream, OutputStream filelistsStream, OutputStream otherStream, XmlContext xml) {
            this.primaryStream = primaryStream;
            this.filelistsStream = filelistsStream;
            this.otherStream = otherStream;
            this.xml = xml;
            this.primary = xml.createDocument();
            this.primaryRoot = this.primary.createElementNS("http://linux.duke.edu/metadata/common", "metadata");
            this.primaryRoot.setAttribute("xmlns:rpm", "http://linux.duke.edu/metadata/rpm");
            this.primary.appendChild(this.primaryRoot);
            this.filelists = xml.createDocument();
            this.filelistsRoot = this.filelists.createElementNS("http://linux.duke.edu/metadata/filelists", "filelists");
            this.filelists.appendChild(this.filelistsRoot);
            this.other = xml.createDocument();
            this.otherRoot = this.other.createElementNS("http://linux.duke.edu/metadata/other", "otherdata");
            this.other.appendChild(this.otherRoot);
        }

        @Override
        public void addPackage(FileInformation fileInformation, RpmInformation info, Map<HashAlgorithm, String> checksums, HashAlgorithm idType) {
            Objects.requireNonNull(fileInformation);
            Objects.requireNonNull(info);
            Objects.requireNonNull(checksums);
            Objects.requireNonNull(idType);
            String id = checksums.get((Object)idType);
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException(String.format("Checksums map did not contain a value for the ID type: %s", new Object[]{idType}));
            }
            ++this.count;
            this.insertToPrimary(fileInformation, info, checksums, idType);
            Element pkg = this.createPackage(this.filelistsRoot, id, info);
            this.appendFiles(info, pkg, null, null);
            pkg = this.createPackage(this.otherRoot, id, info);
            for (RpmInformation.Changelog log : info.getChangelog()) {
                Element cl = RepositoryCreator.addElement(pkg, "changelog", log.getText());
                cl.setAttribute("author", log.getAuthor());
                cl.setAttribute("date", "" + log.getTimestamp());
            }
        }

        private void appendFiles(RpmInformation info, Element pkg, Predicate<String> fileFilter, Predicate<String> dirFilter) {
            for (String file : new TreeSet<String>(info.getFiles())) {
                if (fileFilter != null && !fileFilter.test(file)) continue;
                RepositoryCreator.addElement(pkg, "file", file);
            }
            for (String dir : new TreeSet<String>(info.getDirectories())) {
                if (dirFilter != null && !dirFilter.test(dir)) continue;
                Element ele = RepositoryCreator.addElement(pkg, "file", dir);
                ele.setAttribute("type", "dir");
            }
        }

        private void insertToPrimary(FileInformation fileInformation, RpmInformation info, Map<HashAlgorithm, String> checksums, HashAlgorithm idType) {
            Element pkg = RepositoryCreator.addElement(this.primaryRoot, "package");
            pkg.setAttribute("type", "rpm");
            RepositoryCreator.addElement(pkg, "name", info.getName());
            RepositoryCreator.addElement(pkg, "arch", info.getArchitecture());
            this.addVersion(pkg, info.getVersion());
            for (Map.Entry<HashAlgorithm, String> entry : checksums.entrySet()) {
                Element checksum = RepositoryCreator.addElement(pkg, "checksum", entry.getValue());
                checksum.setAttribute("type", entry.getKey().getId());
                if (entry.getKey() != idType) continue;
                checksum.setAttribute("pkgid", "YES");
            }
            RepositoryCreator.addElement(pkg, "summary", info.getSummary());
            RepositoryCreator.addElement(pkg, "description", info.getDescription());
            RepositoryCreator.addElement(pkg, "packager", info.getPackager());
            RepositoryCreator.addElement(pkg, "url", info.getUrl());
            Element time = RepositoryCreator.addElement(pkg, "time");
            time.setAttribute("file", "" + fileInformation.getTimestamp().getEpochSecond());
            if (info.getBuildTimestamp() != null) {
                time.setAttribute("build", "" + info.getBuildTimestamp());
            }
            Element size = RepositoryCreator.addElement(pkg, "size");
            size.setAttribute("package", "" + fileInformation.getSize());
            if (info.getInstalledSize() != null) {
                size.setAttribute("installed", "" + info.getInstalledSize());
            }
            if (info.getArchiveSize() != null) {
                size.setAttribute("archive", "" + info.getArchiveSize());
            }
            Element location = RepositoryCreator.addElement(pkg, "location");
            location.setAttribute("href", fileInformation.getLocation());
            Element fmt = RepositoryCreator.addElement(pkg, "format");
            RepositoryCreator.addOptionalElement(fmt, "rpm:license", info.getLicense());
            RepositoryCreator.addOptionalElement(fmt, "rpm:vendor", info.getVendor());
            RepositoryCreator.addOptionalElement(fmt, "rpm:group", info.getGroup());
            RepositoryCreator.addOptionalElement(fmt, "rpm:buildhost", info.getBuildHost());
            RepositoryCreator.addOptionalElement(fmt, "rpm:sourcerpm", info.getSourcePackage());
            Element rng = RepositoryCreator.addElement(fmt, "rpm:header-range");
            rng.setAttribute("start", "" + info.getHeaderStart());
            rng.setAttribute("end", "" + info.getHeaderEnd());
            this.addDependencies(fmt, "rpm:provides", info.getProvides());
            this.addDependencies(fmt, "rpm:requires", info.getRequires());
            this.addDependencies(fmt, "rpm:conflicts", info.getConflicts());
            this.addDependencies(fmt, "rpm:obsoletes", info.getObsoletes());
            this.appendFiles(info, pkg, file -> RepositoryCreator.this.matches(file, RepositoryCreator.this.primaryFiles), dir -> RepositoryCreator.this.matches(dir, RepositoryCreator.this.primaryDirs));
        }

        private void addDependencies(Element fmt, String elementName, List<RpmInformation.Dependency> deps) {
            Element ele = RepositoryCreator.addElement(fmt, elementName);
            for (RpmInformation.Dependency dep : deps) {
                boolean pre;
                EnumSet<RpmDependencyFlags> flags = RpmDependencyFlags.parse(dep.getFlags());
                if (flags.contains((Object)RpmDependencyFlags.RPMLIB)) continue;
                Element entry = RepositoryCreator.addElement(ele, "rpm:entry");
                entry.setAttribute("name", dep.getName());
                if (dep.getVersion() != null) {
                    RpmVersion version = RpmVersion.valueOf(dep.getVersion());
                    entry.setAttribute("epoch", "" + version.getEpoch().orElse(0));
                    entry.setAttribute("ver", version.getVersion());
                    if (version.getRelease().isPresent()) {
                        entry.setAttribute("rel", version.getRelease().get());
                    }
                }
                boolean eq = flags.contains((Object)RpmDependencyFlags.EQUAL);
                if (flags.contains((Object)RpmDependencyFlags.GREATER)) {
                    entry.setAttribute("flags", eq ? "GE" : "GT");
                } else if (flags.contains((Object)RpmDependencyFlags.LESS)) {
                    entry.setAttribute("flags", eq ? "LE" : "LT");
                } else if (eq) {
                    entry.setAttribute("flags", "EQ");
                }
                if (!(pre = flags.contains((Object)RpmDependencyFlags.PREREQ) || flags.contains((Object)RpmDependencyFlags.SCRIPT_PRE) || flags.contains((Object)RpmDependencyFlags.SCRIPT_POST))) continue;
                entry.setAttribute("pre", "1");
            }
        }

        private Element createPackage(Element root, String id, RpmInformation info) {
            Element pkg = RepositoryCreator.addElement(root, "package");
            pkg.setAttribute("pkgid", id);
            pkg.setAttribute("name", info.getName());
            pkg.setAttribute("arch", info.getArchitecture());
            this.addVersion(pkg, info.getVersion());
            return pkg;
        }

        private Element addVersion(Element pkg, RpmInformation.Version version) {
            if (version == null) {
                return null;
            }
            Element ver = RepositoryCreator.addElement(pkg, "version");
            if (version.getEpoch() == null || version.getEpoch().isEmpty()) {
                ver.setAttribute("epoch", "0");
            } else {
                ver.setAttribute("epoch", version.getEpoch());
            }
            ver.setAttribute("ver", version.getVersion());
            ver.setAttribute("rel", version.getRelease());
            return ver;
        }

        public void close() throws IOException {
            this.primaryRoot.setAttribute("packages", Long.toString(this.count));
            this.filelistsRoot.setAttribute("packages", Long.toString(this.count));
            this.otherRoot.setAttribute("packages", Long.toString(this.count));
            try {
                this.xml.write(this.primary, this.primaryStream);
                this.xml.write(this.filelists, this.filelistsStream);
                this.xml.write(this.other, this.otherStream);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static class FileInformation {
        private final Instant timestamp;
        private final long size;
        private final String location;

        public FileInformation(Instant timestamp, long size, String location) {
            this.timestamp = timestamp;
            this.size = size;
            this.location = location;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public long getSize() {
            return this.size;
        }

        public String getLocation() {
            return this.location;
        }
    }

    public static interface Context {
        public void addPackage(FileInformation var1, RpmInformation var2, Map<HashAlgorithm, String> var3, HashAlgorithm var4);
    }

    public static class DefaultXmlContext
    implements XmlContext {
        private final DocumentBuilderFactory documentBuilderFactory;
        private final TransformerFactory transformerFactory;

        public DefaultXmlContext() {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setNamespaceAware(true);
            this.transformerFactory = TransformerFactory.newInstance();
        }

        public DefaultXmlContext(DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) {
            Objects.requireNonNull(documentBuilderFactory);
            Objects.requireNonNull(transformerFactory);
            if (!documentBuilderFactory.isNamespaceAware()) {
                throw new IllegalArgumentException("The provided DocumentBuilderFactory must be namespace aware");
            }
            this.documentBuilderFactory = documentBuilderFactory;
            this.transformerFactory = transformerFactory;
        }

        @Override
        public Document createDocument() {
            try {
                return this.documentBuilderFactory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(Document doc, OutputStream outputStream) throws IOException {
            try {
                Transformer transformer = this.transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(outputStream);
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
    }

    public static interface XmlContext {
        public void write(Document var1, OutputStream var2) throws IOException;

        public Document createDocument();
    }
}

